/*
 * Decompiled with CFR 0.152.
 */
package mca.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mca.entity.VillagerLike;
import mca.entity.ai.relationship.AgeState;
import mca.entity.ai.relationship.Gender;
import mca.entity.ai.relationship.VillagerDimensions;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Mob;

public class VillagerEntityBaseModelMCA<T extends Mob>
extends HumanoidModel<T> {
    protected static final String BREASTS = "breasts";
    protected final ModelPart breasts;
    private float breastSize;
    private VillagerDimensions dimensions;

    public VillagerEntityBaseModelMCA(ModelPart root) {
        super(root);
        this.breasts = root.m_171324_(BREASTS);
    }

    public static MeshDefinition getModelData(CubeDeformation dilation) {
        MeshDefinition modelData = HumanoidModel.m_170681_((CubeDeformation)dilation, (float)0.0f);
        PartDefinition data = modelData.m_171576_();
        data.m_171599_(BREASTS, VillagerEntityBaseModelMCA.newBreasts(dilation, 0), PartPose.f_171404_);
        return modelData;
    }

    protected static CubeListBuilder newBreasts(CubeDeformation dilation, int oy) {
        CubeListBuilder builder = CubeListBuilder.m_171558_();
        builder.m_171514_(18, 21 + oy).m_171488_(-3.25f, -1.25f, -1.5f, 6.0f, 3.0f, 3.0f, dilation);
        return builder;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_, (Object)this.f_102809_);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102811_, (Object)this.f_102812_, (Object)this.f_102813_, (Object)this.f_102814_);
    }

    protected Iterable<ModelPart> breastsParts() {
        return ImmutableList.of((Object)this.breasts);
    }

    public void animateModel(T entity, float limbAngle, float limbDistance, float tickDelta) {
        super.m_6839_(entity, limbDistance, limbAngle, tickDelta);
        this.f_102609_ |= ((VillagerLike)entity).getAgeState() == AgeState.BABY;
    }

    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (((VillagerLike)entity).getAgeState() == AgeState.BABY && !entity.m_20159_()) {
            limbDistance = (float)Math.sin((float)((Mob)entity).f_19797_ / 12.0f);
            limbAngle = (float)Math.cos((float)((Mob)entity).f_19797_ / 9.0f) * 3.0f;
            headYaw += (float)Math.sin((float)((Mob)entity).f_19797_ / 2.0f);
        }
        if (entity.m_6162_()) {
            limbAngle /= 3.0f;
        }
        super.m_6973_(entity, limbAngle /= 0.2f + ((VillagerLike)entity).getRawScaleFactor(), limbDistance, animationProgress, headYaw, headPitch);
        if (((VillagerLike)entity).getVillagerBrain().isPanicking()) {
            float toRadiums = (float)Math.PI / 180;
            float armRaise = ((float)Math.sin(animationProgress / 5.0f) * 30.0f - 180.0f + (float)Math.sin(animationProgress / 3.0f) * 3.0f) * toRadiums;
            float waveSideways = ((float)Math.sin(animationProgress / 2.0f) * 12.0f - 17.0f) * toRadiums;
            this.f_102812_.f_104203_ = armRaise;
            this.f_102812_.f_104205_ = -waveSideways;
            this.f_102811_.f_104203_ = -armRaise;
            this.f_102811_.f_104205_ = waveSideways;
        }
        this.dimensions = ((VillagerLike)entity).getVillagerDimensions();
        this.breastSize = ((VillagerLike)entity).getGenetics().getBreastSize();
        this.breasts.f_104207_ = ((VillagerLike)entity).getGenetics().getGender() == Gender.FEMALE;
        this.breasts.m_104315_(this.f_102810_);
    }

    public void m_102872_(HumanoidModel<T> target) {
        super.m_102872_(target);
        if (target instanceof VillagerEntityBaseModelMCA) {
            VillagerEntityBaseModelMCA m = (VillagerEntityBaseModelMCA)target;
            m.dimensions = this.dimensions;
            m.breastSize = this.breastSize;
            m.breasts.f_104207_ = this.breasts.f_104207_;
            m.breasts.m_104315_(this.breasts);
        }
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        float breastSize;
        float headSize = this.dimensions.getHead();
        matrices.m_85836_();
        matrices.m_85841_(headSize, headSize, headSize);
        this.m_5607_().forEach(a -> a.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha));
        matrices.m_85849_();
        this.m_5608_().forEach(a -> a.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha));
        if (this.breasts.f_104207_ && this.f_102810_.f_104207_ && (breastSize = this.breastSize * this.dimensions.getBreasts()) > 0.0f) {
            matrices.m_85836_();
            matrices.m_85837_(0.015625, 0.175 + (double)breastSize * 0.1, -0.075 - (double)breastSize * 0.05);
            matrices.m_85841_(1.166666f, 0.8f + breastSize * 0.3f, 0.75f + breastSize * 0.45f);
            matrices.m_85841_(breastSize * 0.275f + 0.85f, breastSize * 0.65f + 0.75f, breastSize * 0.65f + 0.75f);
            for (ModelPart part : this.breastsParts()) {
                part.f_104203_ = 0.9424779f;
                part.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
            matrices.m_85849_();
        }
    }
}

