/*
 * Decompiled with CFR 0.152.
 */
package mca.client.resources;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ColorPalette {
    static final Map<ResourceLocation, ColorPalette> REGISTRY = new HashMap<ResourceLocation, ColorPalette>();
    public static final ColorPalette SKIN = new ColorPalette(new ResourceLocation("mca", "textures/colormap/villager_skin.png"));
    public static final ColorPalette HAIR = new ColorPalette(new ResourceLocation("mca", "textures/colormap/villager_hair.png"));
    static final Data EMPTY = new Data(1, 1, new int[]{0xFFFFFF});
    private final ResourceLocation id;
    Data data = EMPTY;

    public ColorPalette(ResourceLocation id) {
        this.id = id;
        REGISTRY.put(id, this);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public float[] getColor(float u, float v, float greenShift) {
        int x = ColorPalette.clampFloor(v, this.data.width - 1);
        int y = ColorPalette.clampFloor(u, this.data.height - 1);
        int color = this.data.colors[y * this.data.height + x];
        float[] result = new float[]{(float)NativeImage.m_85119_((int)color) / 255.0f, (float)NativeImage.m_85103_((int)color) / 255.0f, (float)NativeImage.m_85085_((int)color) / 255.0f};
        if (greenShift > 0.0f) {
            ColorPalette.applyGreenShift(result, greenShift / 255.0f);
        }
        return result;
    }

    private static void applyGreenShift(float[] color, float greenShift) {
        float percentDown = 1.0f - greenShift / 1.8f;
        color[0] = Mth.m_14036_((float)(color[0] * percentDown), (float)0.0f, (float)1.0f);
        color[1] = Mth.m_14036_((float)(color[1] * percentDown), (float)0.0f, (float)1.0f);
        color[2] = Mth.m_14036_((float)(color[2] * percentDown), (float)0.0f, (float)1.0f);
    }

    private static int clampFloor(float v, int max) {
        return (int)Math.floor(Mth.m_14036_((float)(v * (float)max), (float)0.0f, (float)max));
    }

    static class Data {
        final int width;
        final int height;
        final int[] colors;

        public Data(int width, int height, int[] colors) {
            this.width = width;
            this.height = height;
            this.colors = colors;
        }
    }
}

