/*
 * Decompiled with CFR 0.152.
 */
package mca.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;

public interface Infectable {
    public static final float MAX_INFECTION = 255.0f;
    public static final float INITIAL_INFECTION_AMOUNT = 1.0f;
    public static final float MIN_INFECTION = 0.0f;
    public static final float FEVER_THRESHOLD = 80.0f;
    public static final float BABBLING_THRESHOLD = 150.0f;
    public static final float POINT_OF_NO_RETURN = 200.0f;

    default public boolean isInfected() {
        return this.getInfectionProgress() > 0.0f;
    }

    default public void setInfected(boolean infected) {
        this.setInfectionProgress(infected ? Math.max(this.getInfectionProgress(), 1.0f) : 0.0f);
    }

    default public boolean canBeTargetedBy(Entity mob) {
        return this instanceof Monster || !(mob instanceof Monster) || this.getInfectionProgress() < 200.0f;
    }

    public float getInfectionProgress();

    default public float getPrevInfectionProgress() {
        return this.getInfectionProgress();
    }

    public void setInfectionProgress(float var1);
}

