/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import mca.entity.ai.brain.sensor.ExplodingCreeperSensor;
import mca.entity.ai.brain.sensor.GuardEnemiesSensor;
import mca.entity.ai.brain.sensor.VillagerMCABabiesSensor;
import mca.mixin.MixinActivity;
import mca.mixin.MixinSensorType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public interface ActivityMCA {
    public static final DeferredRegister<Activity> ACTIVITIES = DeferredRegister.create((String)"mca", (ResourceKey)Registry.f_122814_);
    public static final DeferredRegister<SensorType<?>> SENSORS = DeferredRegister.create((String)"mca", (ResourceKey)Registry.f_122812_);
    public static final RegistrySupplier<Activity> CHORE = ActivityMCA.activity("chore");
    public static final RegistrySupplier<Activity> GRIEVE = ActivityMCA.activity("grieve");
    public static final RegistrySupplier<SensorType<ExplodingCreeperSensor>> EXPLODING_CREEPER = ActivityMCA.sensor("exploding_creeper", ExplodingCreeperSensor::new);
    public static final RegistrySupplier<SensorType<GuardEnemiesSensor>> GUARD_ENEMIES = ActivityMCA.sensor("guard_enemies", GuardEnemiesSensor::new);
    public static final RegistrySupplier<SensorType<VillagerMCABabiesSensor>> VILLAGER_BABIES = ActivityMCA.sensor("villager_babies_mca", VillagerMCABabiesSensor::new);

    public static void bootstrap() {
        ACTIVITIES.register();
        SENSORS.register();
    }

    public static RegistrySupplier<Activity> activity(String name) {
        ResourceLocation id = new ResourceLocation("mca", name);
        return ACTIVITIES.register(id, () -> MixinActivity.init(id.toString()));
    }

    public static <T extends Sensor<?>> RegistrySupplier<SensorType<T>> sensor(String name, Supplier<T> factory) {
        ResourceLocation id = new ResourceLocation("mca", name);
        return SENSORS.register(id, () -> MixinSensorType.init(factory));
    }
}

