/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mca.entity.ai.relationship.AgeState;
import net.minecraft.locale.Language;

public enum DialogueType {
    ADULT(null),
    UNASSIGNED(ADULT),
    BABY(UNASSIGNED),
    CHILD(ADULT),
    CHILDP(CHILD),
    TODDLER(CHILD),
    TODDLERP(CHILDP),
    SPOUSE(ADULT),
    TEEN(ADULT),
    TEENP(TEEN);

    public final DialogueType fallback;
    private static final DialogueType[] VALUES;
    public static final Map<String, DialogueType> MAP;

    private DialogueType(DialogueType fallback) {
        this.fallback = fallback;
    }

    public DialogueType toChild() {
        return switch (this) {
            case TODDLER -> TODDLERP;
            case CHILD -> CHILDP;
            case TEEN -> TEENP;
            default -> UNASSIGNED;
        };
    }

    public static DialogueType fromAge(AgeState state) {
        for (DialogueType t : DialogueType.values()) {
            if (!t.name().equals(state.name())) continue;
            return t;
        }
        return UNASSIGNED;
    }

    public static DialogueType byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return UNASSIGNED;
        }
        return VALUES[id];
    }

    public static String applyFallback(String key) {
        int split = key.indexOf(".");
        if (split <= 0) {
            return key;
        }
        DialogueType type = MAP.get(key.substring(0, split));
        if (type == null) {
            return key;
        }
        String phrase = key.substring(split + 1);
        while (type != null) {
            String s = type.name().toLowerCase(Locale.ENGLISH) + "." + phrase;
            if (Language.m_128107_().m_6722_(s)) {
                return s;
            }
            type = type.fallback;
        }
        return phrase;
    }

    static {
        VALUES = DialogueType.values();
        MAP = Arrays.stream(VALUES).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

