/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import java.util.Arrays;
import java.util.List;
import mca.SoundsMCA;
import mca.entity.ai.Mood;
import mca.entity.ai.MoodBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public enum MoodGroup {
    UNASSIGNED(new MoodBuilder("passive").build()),
    GENERAL(new MoodBuilder("depressed").sounds(2, (SoundEvent)SoundsMCA.VILLAGER_MALE_CRY.get(), (SoundEvent)SoundsMCA.VILLAGER_FEMALE_CRY.get()).particles(20, ParticleTypes.f_123769_).building("inn").color(ChatFormatting.RED).build(), new MoodBuilder("sad").sounds(8, (SoundEvent)SoundsMCA.VILLAGER_MALE_CRY.get(), (SoundEvent)SoundsMCA.VILLAGER_FEMALE_CRY.get()).particles(50, ParticleTypes.f_123769_).building("inn").color(ChatFormatting.GOLD).build(), new MoodBuilder("unhappy").build(), new MoodBuilder("passive").build(), new MoodBuilder("fine").build(), new MoodBuilder("happy").color(ChatFormatting.DARK_GREEN).build(), new MoodBuilder("overjoyed").sounds(8, (SoundEvent)SoundsMCA.VILLAGER_MALE_LAUGH.get(), (SoundEvent)SoundsMCA.VILLAGER_FEMALE_LAUGH.get()).particles(50, ParticleTypes.f_123748_).color(ChatFormatting.GREEN).build()),
    PLAYFUL(new MoodBuilder("bored_to_tears").color(ChatFormatting.RED).build(), new MoodBuilder("bored").color(ChatFormatting.GOLD).build(), new MoodBuilder("uninterested").build(), new MoodBuilder("passive").build(), new MoodBuilder("silly").build(), new MoodBuilder("giggly").sounds(8, (SoundEvent)SoundsMCA.VILLAGER_MALE_LAUGH.get(), (SoundEvent)SoundsMCA.VILLAGER_FEMALE_LAUGH.get()).particles(50, ParticleTypes.f_123748_).building("inn").color(ChatFormatting.DARK_GREEN).build(), new MoodBuilder("entertained").sounds(2, (SoundEvent)SoundsMCA.VILLAGER_MALE_LAUGH.get(), (SoundEvent)SoundsMCA.VILLAGER_FEMALE_LAUGH.get()).particles(20, ParticleTypes.f_123748_).building("inn").color(ChatFormatting.GREEN).build()),
    SERIOUS(new MoodBuilder("infuriated").sounds(2, (SoundEvent)SoundsMCA.VILLAGER_MALE_ANGRY.get(), (SoundEvent)SoundsMCA.VILLAGER_FEMALE_ANGRY.get()).particles(20, ParticleTypes.f_123792_).color(ChatFormatting.RED).build(), new MoodBuilder("angry").sounds(8, (SoundEvent)SoundsMCA.VILLAGER_MALE_ANGRY.get(), (SoundEvent)SoundsMCA.VILLAGER_FEMALE_ANGRY.get()).particles(50, ParticleTypes.f_123792_).color(ChatFormatting.GOLD).build(), new MoodBuilder("annoyed").build(), new MoodBuilder("passive").build(), new MoodBuilder("interested").build(), new MoodBuilder("talkative").building("inn").color(ChatFormatting.DARK_GREEN).build(), new MoodBuilder("pleased").color(ChatFormatting.GREEN).build());

    public static final int normalMinLevel = -15;
    public static final int absoluteMinLevel = -100;
    public static final int maxLevel = 15;
    private final List<Mood> moods;

    private MoodGroup(Mood ... m) {
        this.moods = Arrays.asList(m);
    }

    public static int clampMood(int moodPoints) {
        return Mth.m_14045_((int)moodPoints, (int)-100, (int)15);
    }

    private int getLevel(int moodPoints) {
        return Mth.m_14045_((int)((moodPoints - -15) * this.moods.size() / 30), (int)0, (int)(this.moods.size() - 1));
    }

    public Mood getMood(int moodPoints) {
        int level = this.getLevel(moodPoints);
        return this.moods.get(level);
    }
}

