/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mca.entity.VillagerEntityMCA;
import mca.server.world.data.Building;
import mca.server.world.data.GraveyardManager;
import mca.server.world.data.Village;
import mca.server.world.data.VillageManager;
import mca.util.network.datasync.CDataManager;
import mca.util.network.datasync.CDataParameter;
import mca.util.network.datasync.CParameter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;

public class Residency {
    private static final CDataParameter<Integer> BUILDING = CParameter.create("buildings", -1);
    private static final CDataParameter<BlockPos> HANGOUT = CParameter.create("hangoutPos", BlockPos.f_121853_);
    private final VillagerEntityMCA entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(BUILDING, HANGOUT);
    }

    public Residency(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public BlockPos getWorkplace() {
        return this.entity.m_6274_().m_21952_(MemoryModuleType.f_26360_).map(GlobalPos::m_122646_).orElse(BlockPos.f_121853_);
    }

    public void setWorkplace(Player player) {
        this.entity.sendChatMessage(player, "interaction.setworkplace.success", new Object[0]);
        this.entity.m_6274_().m_21936_(MemoryModuleType.f_26360_);
        this.entity.m_6274_().m_21936_(MemoryModuleType.f_26361_);
    }

    public BlockPos getHangout() {
        return (BlockPos)this.entity.getTrackedValue(HANGOUT);
    }

    public void setHangout(Player player) {
        this.entity.sendChatMessage(player, "interaction.sethangout.success", new Object[0]);
        this.entity.setTrackedValue(HANGOUT, player.m_142538_());
    }

    public void setBuildingId(int id) {
        this.entity.setTrackedValue(BUILDING, id);
    }

    public Optional<Village> getHomeVillage() {
        VillageManager manager = VillageManager.get((ServerLevel)this.entity.f_19853_);
        return manager.getOrEmpty(manager.mapBuildingToVillage((Integer)this.entity.getTrackedValue(BUILDING)));
    }

    public Optional<Building> getHomeBuilding() {
        Optional<Building> building = this.getHomeVillage().flatMap(v -> v.getBuilding((Integer)this.entity.getTrackedValue(BUILDING)));
        if (building.isEmpty()) {
            this.setHomeLess();
        }
        return building;
    }

    public void leaveHome() {
        VillageManager manager = VillageManager.get((ServerLevel)this.entity.f_19853_);
        Optional<Village> village = this.getHomeVillage();
        village.ifPresent(v -> {
            Optional<Building> building = v.getBuilding((Integer)this.entity.getTrackedValue(BUILDING));
            if (building.isPresent()) {
                building.get().getResidents().remove(this.entity.m_142081_());
                manager.m_77762_();
            }
            v.cleanReputation();
            v.markDirty((ServerLevel)this.entity.f_19853_);
        });
    }

    public Optional<GlobalPos> getHome() {
        return this.getHomeBuilding().map(building -> GlobalPos.m_122643_((ResourceKey)this.entity.f_19853_.m_46472_(), (BlockPos)building.getCenter()));
    }

    public void tick() {
        if (this.entity.f_19797_ % 600 == 0) {
            if (this.getHomeVillage().filter(v -> !v.isAutoScan()).isEmpty()) {
                this.reportBuildings();
            }
            if ((Integer)this.entity.getTrackedValue(BUILDING) == -1) {
                Village.findNearest((Entity)this.entity).ifPresent(this::seekNewHome);
            }
        }
        if (this.entity.f_19797_ % 1200 == 0) {
            this.getHomeVillage().ifPresentOrElse(village -> {
                Optional<Building> building = village.getBuilding((Integer)this.entity.getTrackedValue(BUILDING));
                if (building.filter(b -> b.hasResident(this.entity.m_142081_()) && !b.isCrowded()).isEmpty()) {
                    if (building.isPresent()) {
                        this.setHomeLess();
                    }
                } else {
                    Optional globalPos = this.entity.getMCABrain().m_21952_(MemoryModuleType.f_26359_);
                    if (globalPos.isPresent() && !building.get().containsPos((Vec3i)((GlobalPos)globalPos.get()).m_122646_())) {
                        this.setHomeLess();
                        return;
                    }
                    int mood = village.popMood((ServerLevel)this.entity.f_19853_);
                    if (mood != 0) {
                        this.entity.getVillagerBrain().modifyMoodValue(mood);
                    }
                    this.entity.f_19853_.m_6907_().forEach(player -> {
                        int rep = village.popHearts((Player)player);
                        if (rep != 0) {
                            this.entity.getVillagerBrain().getMemoriesForPlayer((Player)player).modHearts(rep);
                        }
                    });
                    this.entity.f_19853_.m_6907_().forEach(player -> {
                        int hearts = this.entity.getVillagerBrain().getMemoriesForPlayer((Player)player).getHearts();
                        village.setReputation((Player)player, this.entity, hearts);
                    });
                }
            }, this::setHomeLess);
        }
    }

    private void setHomeLess() {
        Optional<Village> village = this.getHomeVillage();
        village.ifPresent(buildings -> buildings.removeResident(this.entity));
        this.setBuildingId(-1);
        this.entity.getMCABrain().m_21936_(MemoryModuleType.f_26359_);
    }

    private void setBuilding(Building b) {
        List<BlockPos> group = b.getBlocksOfGroup(new ResourceLocation("minecraft:beds"));
        if (group.size() > 0) {
            this.setBuilding(b, group.get(b.getResidents().size() % group.size()));
        } else {
            this.setBuilding(b, b.getCenter());
        }
    }

    private void setBuilding(Building b, BlockPos p) {
        this.setBuildingId(b.getId());
        this.entity.getMCABrain().m_21879_(MemoryModuleType.f_26359_, (Object)GlobalPos.m_122643_((ResourceKey)this.entity.f_19853_.m_46472_(), (BlockPos)p));
    }

    private void reportBuildings() {
        VillageManager manager = VillageManager.get((ServerLevel)this.entity.f_19853_);
        Stream stream = ((ServerLevel)this.entity.f_19853_).m_8904_().m_27138_(PoiType.f_27330_, p -> !manager.cache.contains(p), this.entity.m_142538_(), 48, PoiManager.Occupancy.ANY);
        stream.forEach(manager::reportBuilding);
        GraveyardManager.get((ServerLevel)this.entity.f_19853_).reportToVillageManager((Entity)this.entity);
    }

    private boolean seekNewHome(Village village) {
        List<Building> buildings = village.getBuildings().values().stream().filter(Building::hasFreeSpace).toList();
        if (!buildings.isEmpty()) {
            Building b = buildings.get(this.entity.m_21187_().nextInt(buildings.size()));
            this.setBuilding(b);
            village.addResident(this.entity, b.getId());
            return true;
        }
        return false;
    }

    public void setHome(Player player) {
        VillageManager manager = VillageManager.get((ServerLevel)player.f_19853_);
        manager.processBuilding(player.m_142538_(), true, false);
        manager.findNearestVillage((Entity)player).ifPresentOrElse(village -> village.getBuildingAt((Vec3i)player.m_142538_()).ifPresentOrElse(building -> {
            if (building.hasFreeSpace()) {
                this.entity.sendChatMessage(player, "interaction.sethome.success", new Object[0]);
                this.setHomeLess();
                this.setBuilding((Building)building, player.m_142538_());
                village.addResident(this.entity, building.getId());
            } else if (building.getBuildingType().noBeds()) {
                this.entity.sendChatMessage(player, "interaction.sethome.bedfail." + building.getBuildingType().name(), new Object[0]);
            } else if (building.getBedCount() == 0) {
                this.entity.sendChatMessage(player, "interaction.sethome.nobeds", new Object[0]);
            } else {
                this.entity.sendChatMessage(player, "interaction.sethome.bedfail", new Object[0]);
            }
        }, () -> this.entity.sendChatMessage(player, "interaction.sethome.fail", new Object[0])), () -> this.entity.sendChatMessage(player, "interaction.sethome.fail", new Object[0]));
    }

    public void goHome(Player player) {
        this.getHome().filter(p -> p.m_122640_() == this.entity.f_19853_.m_46472_()).ifPresentOrElse(home -> {
            this.entity.moveTowards(home.m_122646_());
            this.entity.sendChatMessage(player, "interaction.gohome.success", new Object[0]);
        }, () -> this.entity.sendChatMessage(player, "interaction.gohome.fail.nohome", new Object[0]));
    }
}

