/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain.tasks;

import java.util.Optional;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.ProfessionsMCA;
import mca.entity.ai.brain.tasks.EnterBuildingTask;
import mca.server.world.data.Building;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class EnterFavoredBuildingTask
extends EnterBuildingTask {
    private int lastMoodIncrease = 0;
    private static final int TICKS_PER_MOOD = 1200;

    public EnterFavoredBuildingTask(float speed) {
        super("", speed);
    }

    @Override
    public String getBuilding(VillagerEntityMCA villager) {
        String building = villager.getVillagerBrain().getMood().getBuilding();
        if (building != null) {
            return building;
        }
        return ProfessionsMCA.getFavoredBuilding(villager.getProfession());
    }

    @Override
    protected Optional<BlockPos> getNextPosition(VillagerEntityMCA villager) {
        Optional<Building> b = this.getNearestBuilding(villager);
        if (b.isPresent()) {
            if (b.get().containsPos((Vec3i)villager.m_142538_())) {
                if (villager.f_19797_ > this.lastMoodIncrease + 1200 && villager.getVillagerBrain().getMoodValue() < 0) {
                    this.lastMoodIncrease = villager.f_19797_;
                    villager.getVillagerBrain().modifyMoodValue(1);
                }
            } else {
                return this.getRandomPositionIn(b.get(), villager.f_19853_);
            }
        }
        return Optional.empty();
    }
}

