/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain.tasks.chore;

import java.util.Map;
import java.util.Optional;
import mca.MCA;
import mca.entity.VillagerEntityMCA;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractChoreTask
extends Behavior<VillagerEntityMCA> {
    protected VillagerEntityMCA villager;

    public AbstractChoreTask(Map<MemoryModuleType<?>, MemoryStatus> requirements) {
        super(requirements);
    }

    protected void keepRunning(ServerLevel world, VillagerEntityMCA entity, long time) {
        if (this.getAssigningPlayer().isEmpty()) {
            MCA.LOGGER.info("Force-stopped chore because assigning player was not present.");
            this.villager.getVillagerBrain().abandonJob();
        }
    }

    protected void run(ServerLevel world, VillagerEntityMCA entity, long time) {
        this.villager = entity;
    }

    Optional<Player> getAssigningPlayer() {
        return this.villager.getVillagerBrain().getJobAssigner();
    }

    void abandonJobWithMessage(String message) {
        this.getAssigningPlayer().ifPresent(player -> this.villager.sendChatMessage((Player)player, message, new Object[0]));
        this.villager.getVillagerBrain().abandonJob();
    }
}

