/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.relationship.family;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.relationship.Gender;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.util.NbtHelper;
import mca.util.WorldUtils;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FamilyTree
extends SavedData {
    private static final String DATA_ID = "MCA-FamilyTree";
    private final Map<UUID, FamilyTreeNode> entries;

    public static FamilyTree get(ServerLevel world) {
        return WorldUtils.loadData(world.m_142572_().m_129783_(), FamilyTree::new, FamilyTree::new, DATA_ID);
    }

    FamilyTree(ServerLevel world) {
        this.entries = new HashMap<UUID, FamilyTreeNode>();
    }

    FamilyTree(CompoundTag nbt) {
        this.entries = NbtHelper.toMap(nbt, UUID::fromString, (id, element) -> new FamilyTreeNode(this, (UUID)id, (CompoundTag)element));
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        return NbtHelper.fromMap(nbt, this.entries, UUID::toString, FamilyTreeNode::save);
    }

    public Optional<FamilyTreeNode> getOrEmpty(@Nullable UUID id) {
        return id == null ? Optional.empty() : Optional.ofNullable(this.entries.get(id));
    }

    public Stream<FamilyTreeNode> getAllWithName(String name) {
        return this.entries.values().stream().filter(n -> n.getName().equals(name));
    }

    @NotNull
    public FamilyTreeNode getOrCreate(Entity entity) {
        return this.entries.computeIfAbsent(entity.m_142081_(), uuid -> this.createEntry(entity, Util.f_137441_, Util.f_137441_));
    }

    @NotNull
    public FamilyTreeNode getOrCreate(UUID id, String name, Gender gender) {
        return this.entries.computeIfAbsent(id, uuid -> this.createEntry((UUID)uuid, name, gender));
    }

    private FamilyTreeNode createEntry(UUID uuid, String name, Gender gender) {
        this.m_77762_();
        return new FamilyTreeNode(this, uuid, name, false, gender, Util.f_137441_, Util.f_137441_);
    }

    private FamilyTreeNode createEntry(Entity entity, UUID father, UUID mother) {
        this.m_77762_();
        return new FamilyTreeNode(this, entity.m_142081_(), entity.m_7755_().getString(), entity instanceof Player, entity instanceof VillagerEntityMCA ? ((VillagerEntityMCA)entity).getGenetics().getGender() : Gender.MALE, father, mother);
    }
}

