/*
 * Decompiled with CFR 0.152.
 */
package mca.mixin;

import mca.server.SpawnQueue;
import mca.server.world.data.VillageManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
abstract class MixinServerWorld
extends Level
implements WorldGenLevel {
    MixinServerWorld() {
        super(null, null, null, null, true, false, 0L);
    }

    @Inject(method={"addEntity(Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddEntity(Entity entity, CallbackInfoReturnable<Boolean> info) {
        if (SpawnQueue.getInstance().addVillager(entity)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onBlockChanged(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;)V"}, at={@At(value="HEAD")})
    public void onOnBlockChanged(BlockPos pos, BlockState oldBlock, BlockState newBlock, CallbackInfo info) {
        if (oldBlock.m_60734_() != newBlock.m_60734_()) {
            ServerLevel self = (ServerLevel)this;
            self.m_142572_().execute(() -> VillageManager.get(self).getReaperSpawner().trySpawnReaper(self, newBlock, pos));
        }
    }
}

