/*
 * Decompiled with CFR 0.152.
 */
package mca.network.c2s;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import mca.cobalt.network.Message;
import mca.entity.VillagerEntityMCA;
import mca.entity.VillagerLike;
import mca.entity.ai.relationship.Gender;
import mca.entity.ai.relationship.family.FamilyTree;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.network.NbtDataMessage;
import mca.network.c2s.GetVillagerRequest;
import mca.resources.ClothingList;
import mca.resources.HairList;
import mca.resources.data.Hair;
import mca.server.world.data.PlayerSaveData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;

public class VillagerEditorSyncRequest
extends NbtDataMessage
implements Message {
    private static final long serialVersionUID = -5581564927127176555L;
    private final String command;
    private final UUID uuid;

    public VillagerEditorSyncRequest(String command, UUID uuid, CompoundTag data) {
        super(data);
        this.command = command;
        this.uuid = uuid;
    }

    @Override
    public void receive(ServerPlayer player) {
        Entity entity = player.m_183503_().m_8791_(this.uuid);
        switch (this.command) {
            case "hair": {
                CompoundTag villagerData = GetVillagerRequest.getVillagerData(entity);
                if (villagerData == null) break;
                Hair hair = HairList.getInstance().pickNext(this.getGender(villagerData), new Hair(villagerData.m_128461_("hair"), villagerData.m_128461_("hairOverlay")), this.getData().m_128451_("offset"));
                villagerData.m_128359_("hair", hair.texture());
                villagerData.m_128359_("hairOverlay", hair.overlay());
                this.saveEntity(player, entity, villagerData);
                break;
            }
            case "clothing": {
                CompoundTag villagerData = GetVillagerRequest.getVillagerData(entity);
                if (villagerData == null) break;
                String clothes = "";
                if (entity instanceof Player) {
                    clothes = ClothingList.getInstance().getPool(this.getGender(villagerData), VillagerProfession.f_35585_).pickNext(villagerData.m_128461_("clothes"), this.getData().m_128451_("offset"));
                } else if (entity instanceof VillagerLike) {
                    VillagerLike villager = (VillagerLike)entity;
                    clothes = ClothingList.getInstance().getPool(villager).pickNext(villager.getClothes(), this.getData().m_128451_("offset"));
                }
                villagerData.m_128359_("clothes", clothes);
                this.saveEntity(player, entity, villagerData);
                break;
            }
            case "sync": {
                this.saveEntity(player, entity, this.getData());
                break;
            }
            case "profession": {
                if (!(entity instanceof VillagerEntityMCA)) break;
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                VillagerProfession profession = (VillagerProfession)Registry.f_122869_.m_7745_(new ResourceLocation(this.getData().m_128461_("profession")));
                villager.setProfession(profession);
            }
        }
        this.getData();
    }

    private void saveEntity(ServerPlayer player, Entity entity, CompoundTag villagerData) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PlayerSaveData data = PlayerSaveData.get(serverPlayer.m_183503_(), this.uuid);
            data.setEntityData(villagerData);
            data.setEntityDataSet(true);
            this.syncFamilyTree(player, entity, villagerData);
        } else if (entity instanceof VillagerLike) {
            ((LivingEntity)entity).m_7378_(villagerData);
            entity.m_6210_();
            this.syncFamilyTree(player, entity, villagerData);
        }
    }

    private Gender getGender(CompoundTag villagerData) {
        return Gender.byId(villagerData.m_128451_("gender"));
    }

    private Optional<FamilyTreeNode> getFamilyNode(ServerPlayer player, FamilyTree tree, String name, Gender gender) {
        try {
            UUID uuid = UUID.fromString(name);
            Optional<FamilyTreeNode> node = tree.getOrEmpty(uuid);
            if (node.isPresent()) {
                player.m_5661_((Component)new TranslatableComponent("gui.villager_editor.uuid_known", new Object[]{name, node.get().getName()}), true);
                return node;
            }
            player.m_5661_((Component)new TranslatableComponent("gui.villager_editor.uuid_unknown", new Object[]{name}).m_130940_(ChatFormatting.RED), true);
            return Optional.empty();
        }
        catch (IllegalArgumentException exception) {
            List<FamilyTreeNode> nodes = tree.getAllWithName(name).toList();
            if (nodes.isEmpty()) {
                player.m_5661_((Component)new TranslatableComponent("gui.villager_editor.name_created", new Object[]{name}).m_130940_(ChatFormatting.YELLOW), true);
                return Optional.of(tree.getOrCreate(UUID.randomUUID(), name, gender));
            }
            if (nodes.size() > 1) {
                player.m_5661_((Component)new TranslatableComponent("gui.villager_editor.name_not_unique", new Object[]{name}).m_130940_(ChatFormatting.RED), true);
                String uuids = nodes.stream().map(FamilyTreeNode::id).map(UUID::toString).collect(Collectors.joining(", "));
                player.m_5661_((Component)new TranslatableComponent("gui.villager_editor.list_of_ids", new Object[]{uuids}), false);
            } else {
                player.m_5661_((Component)new TranslatableComponent("gui.villager_editor.name_unique", new Object[]{name}), true);
            }
            return Optional.ofNullable(nodes.get(0));
        }
    }

    private void syncFamilyTree(ServerPlayer player, Entity entity, CompoundTag villagerData) {
        String name;
        FamilyTree tree = FamilyTree.get((ServerLevel)entity.f_19853_);
        FamilyTreeNode entry = tree.getOrCreate(entity);
        entry.setGender(this.getGender(this.getData()));
        entry.setName(this.getData().m_128461_("villagerName"));
        if (villagerData.m_128441_("tree_father_new")) {
            name = villagerData.m_128461_("tree_father_new");
            if (name.isEmpty()) {
                entry.removeFather();
            } else {
                this.getFamilyNode(player, tree, name, Gender.MALE).ifPresent(entry::setFather);
            }
        }
        if (villagerData.m_128441_("tree_mother_new")) {
            name = villagerData.m_128461_("tree_mother_new");
            if (name.isEmpty()) {
                entry.removeMother();
            } else {
                this.getFamilyNode(player, tree, name, Gender.FEMALE).ifPresent(entry::setMother);
            }
        }
        if (villagerData.m_128441_("tree_spouse_new")) {
            name = villagerData.m_128461_("tree_spouse_new");
            if (name.isEmpty()) {
                Optional.of(entry.spouse()).flatMap(tree::getOrEmpty).ifPresent(node -> node.updateMarriage(null, null));
                entry.updateMarriage(null, null);
            } else {
                this.getFamilyNode(player, tree, name, entry.gender().opposite()).ifPresent(node -> {
                    entry.updateMarriage((FamilyTreeNode)node);
                    node.updateMarriage(entry);
                });
            }
        }
    }
}

