/*
 * Decompiled with CFR 0.152.
 */
package mca.resources;

import java.util.Locale;

public enum Rank {
    OUTLAW,
    PEASANT,
    MERCHANT,
    NOBLE,
    MAYOR,
    KING;

    private static final Rank[] VALUES;

    public Rank promote() {
        if (this.ordinal() + 1 < VALUES.length) {
            return VALUES[this.ordinal() + 1];
        }
        return KING;
    }

    public Rank degrade() {
        if (this.ordinal() - 1 >= 0) {
            return VALUES[this.ordinal() - 1];
        }
        return null;
    }

    public static Rank fromName(String name) {
        for (Rank r : VALUES) {
            if (!r.name().equals(name.toUpperCase(Locale.ENGLISH))) continue;
            return r;
        }
        return PEASANT;
    }

    public boolean isAtLeast(Rank r) {
        return this.ordinal() >= r.ordinal();
    }

    static {
        VALUES = Rank.values();
    }
}

