/*
 * Decompiled with CFR 0.152.
 */
package mca.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import mca.MCA;
import mca.entity.interaction.InteractionPredicate;
import mca.resources.InteractionPredicateTypeAdapter;
import org.apache.commons.io.IOUtils;

public interface Resources {
    public static final String RESOURCE_PREFIX = "assets/mca/";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(InteractionPredicate.class, (Object)InteractionPredicateTypeAdapter.INSTANCE).create();

    public static String read(String path) throws IOException {
        return IOUtils.toString((Reader)new InputStreamReader(MCA.class.getClassLoader().getResourceAsStream(RESOURCE_PREFIX + path)));
    }

    public static <T> T read(String path, Type type) throws BrokenResourceException {
        try {
            return (T)GSON.fromJson(Resources.read(path), type);
        }
        catch (JsonParseException | IOException e) {
            throw new BrokenResourceException(path, e);
        }
    }

    public static <T> T read(String path, Class<T> type) throws BrokenResourceException {
        return Resources.read(path, type);
    }

    public static class BrokenResourceException
    extends Exception {
        private static final long serialVersionUID = -7371322414731622879L;

        BrokenResourceException(String path, Throwable cause) {
            super("Unable to load resource from path " + path, cause);
        }
    }
}

