/*
 * Decompiled with CFR 0.152.
 */
package mca.resources;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import mca.entity.ai.relationship.Gender;
import mca.resources.Resources;
import mca.resources.WeightedPool;
import mca.resources.data.BuildingType;
import mca.resources.data.NameSet;
import org.jetbrains.annotations.NotNull;

public class VillageComponents
implements Iterable<BuildingType> {
    private final Map<String, BuildingType> buildingTypes = new HashMap<String, BuildingType>();
    private final Map<String, NameSet> namePool = new HashMap<String, NameSet>();
    private final Map<Gender, WeightedPool<String>> villagerNames = new EnumMap<Gender, WeightedPool<String>>(Gender.class);
    private final Random rng;

    VillageComponents(Random rng) {
        this.rng = rng;
    }

    void load() throws Resources.BrokenResourceException {
        for (BuildingType bt : Resources.read("api/buildingTypes.json", BuildingType[].class)) {
            this.buildingTypes.put(bt.name(), bt);
        }
        this.namePool.put("village", Resources.read("api/names/village.json", NameSet.class));
        this.villagerNames.put(Gender.MALE, this.loadResidentNames("male"));
        this.villagerNames.put(Gender.FEMALE, this.loadResidentNames("female"));
    }

    WeightedPool<String> loadResidentNames(String gender) throws Resources.BrokenResourceException {
        Map names = (Map)Resources.read("api/names/villager/" + gender + ".json", HashMap.class);
        WeightedPool.Mutable<String> pool = new WeightedPool.Mutable<String>("?");
        for (Map.Entry e : names.entrySet()) {
            pool.add((String)e.getKey(), (float)Math.sqrt(((Double)e.getValue()).floatValue()));
        }
        return pool;
    }

    public String pickCitizenName(@NotNull Gender gender) {
        return this.villagerNames.get((Object)gender.binary()).pickOne();
    }

    public String pickVillageName(String from) {
        return this.namePool.getOrDefault(from, NameSet.DEFAULT).toName(this.rng);
    }

    public Map<String, BuildingType> getBuildingTypes() {
        return this.buildingTypes;
    }

    public BuildingType getBuildingType(String type) {
        return this.buildingTypes.containsKey(type) ? this.buildingTypes.get(type) : new BuildingType();
    }

    @Override
    public Iterator<BuildingType> iterator() {
        return this.buildingTypes.values().iterator();
    }
}

