/*
 * Decompiled with CFR 0.152.
 */
package mca.server;

import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mca.Config;
import mca.cobalt.network.NetworkHandler;
import mca.entity.ai.relationship.EntityRelationship;
import mca.entity.ai.relationship.Gender;
import mca.entity.ai.relationship.MarriageState;
import mca.network.s2c.ShowToastRequest;
import mca.server.world.data.BabyTracker;
import mca.server.world.data.PlayerSaveData;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ServerInteractionManager {
    private static final ServerInteractionManager INSTANCE = new ServerInteractionManager();
    private final Map<UUID, List<UUID>> proposals = new HashMap<UUID, List<UUID>>();
    private final Object2LongArrayMap<UUID> procreateMap = new Object2LongArrayMap();

    private ServerInteractionManager() {
    }

    public static ServerInteractionManager getInstance() {
        return INSTANCE;
    }

    public void tick() {
        ArrayList removals = new ArrayList();
        this.procreateMap.keySet().stream().filter(k -> this.procreateMap.getLong(k) < System.currentTimeMillis()).forEach(removals::add);
        removals.forEach(arg_0 -> this.procreateMap.removeLong(arg_0));
    }

    public void onPlayerJoin(ServerPlayer player) {
        PlayerSaveData playerData = PlayerSaveData.get(player.m_183503_(), player.m_142081_());
        if (!playerData.isEntityDataSet()) {
            NetworkHandler.sendToPlayer(new ShowToastRequest("server.playerNotCustomized.title", "server.playerNotCustomized.description"), player);
        }
        if (playerData.hasMail()) {
            playerData.showMailNotification(player);
        }
    }

    private boolean hasProposalFrom(ServerPlayer sender, ServerPlayer receiver) {
        return this.getProposalsFor(receiver).contains(sender.m_142081_());
    }

    private List<UUID> getProposalsFor(ServerPlayer player) {
        return this.proposals.getOrDefault(player.m_142081_(), new ArrayList());
    }

    private void removeProposalFor(ServerPlayer target, ServerPlayer proposer) {
        List<UUID> list = this.getProposalsFor(target);
        list.remove(proposer.m_142081_());
        this.proposals.put(target.m_142081_(), list);
    }

    public void listProposals(ServerPlayer sender) {
        List<UUID> proposals = this.getProposalsFor(sender);
        if (proposals.size() == 0) {
            this.infoMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.noProposals"));
        } else {
            this.infoMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.proposals"));
        }
        proposals.forEach(uuid -> {
            Player player = sender.m_183503_().m_46003_(uuid);
            if (player != null) {
                this.infoMessage((Player)sender, (BaseComponent)new TextComponent("- ").m_7220_((Component)new TextComponent(player.m_6302_())));
            }
        });
    }

    public void sendProposal(ServerPlayer sender, ServerPlayer receiver) {
        if (!Config.getInstance().allowPlayerMarriage) {
            this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("notify.playerMarriage.disabled"));
            return;
        }
        if (PlayerSaveData.get(sender.m_183503_(), sender.m_142081_()).isMarried()) {
            this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.alreadyMarried"));
            return;
        }
        if (sender == receiver) {
            this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.proposedToYourself"));
            return;
        }
        if (this.hasProposalFrom(sender, receiver)) {
            this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.sentProposal", new Object[]{receiver.m_6302_()}));
        } else {
            this.successMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.proposalSent", new Object[]{receiver.m_6302_()}));
            this.infoMessage((Player)receiver, (BaseComponent)new TranslatableComponent("server.proposedMarriage", new Object[]{sender.m_6302_()}));
            List<UUID> list = this.getProposalsFor(receiver);
            list.add(sender.m_142081_());
            this.proposals.put(receiver.m_142081_(), list);
        }
    }

    public void rejectProposal(ServerPlayer sender, ServerPlayer receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.noProposal", new Object[]{receiver.m_5446_()}));
        } else {
            this.successMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.proposalRejectionSent"));
            this.failMessage((Player)receiver, (BaseComponent)new TranslatableComponent("server.proposalRejected", new Object[]{sender.m_6302_()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void acceptProposal(ServerPlayer sender, ServerPlayer receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.noProposal", new Object[]{receiver.m_5446_()}));
        } else {
            this.successMessage((Player)receiver, (BaseComponent)new TranslatableComponent("server.proposalAccepted", new Object[]{sender.m_5446_()}));
            PlayerSaveData.get(sender.m_183503_(), sender.m_142081_()).marry((Entity)receiver);
            PlayerSaveData.get(receiver.m_183503_(), receiver.m_142081_()).marry((Entity)sender);
            this.successMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.married", new Object[]{receiver.m_5446_()}));
            this.successMessage((Player)receiver, (BaseComponent)new TranslatableComponent("server.married", new Object[]{sender.m_5446_()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void endMarriage(ServerPlayer sender) {
        EntityRelationship.of((Entity)sender).ifPresent(senderData -> {
            if (!senderData.isMarried()) {
                this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.endMarriageNotMarried"));
                return;
            }
            if (senderData.getMarriageState() != MarriageState.MARRIED_TO_PLAYER) {
                this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.marriedToVillager"));
                return;
            }
            senderData.getSpouseName().ifPresent(name -> this.successMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.endMarriage", new Object[]{name.getString()})));
            senderData.getSpouse().ifPresent(spouse -> {
                if (spouse instanceof Player) {
                    Player player = (Player)spouse;
                    this.failMessage(player, (BaseComponent)new TranslatableComponent("server.marriageEnded", new Object[]{sender.m_6302_()}));
                }
            });
            senderData.endMarriage(MarriageState.SINGLE);
            senderData.getSpouseUuid().map(id -> PlayerSaveData.get(sender.m_183503_(), id)).ifPresent(r -> r.endMarriage(MarriageState.SINGLE));
        });
    }

    public void procreate(ServerPlayer sender) {
        PlayerSaveData senderData = PlayerSaveData.get(sender.m_183503_(), sender.m_142081_());
        if (!senderData.isMarried()) {
            this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.notMarried"));
            return;
        }
        if (senderData.getMarriageState() != MarriageState.MARRIED_TO_PLAYER) {
            this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.marriedToVillager"));
            return;
        }
        BabyTracker tracker = BabyTracker.get(sender.m_183503_());
        BabyTracker.Pairing pairing = tracker.getPairing(sender.m_142081_(), senderData.getSpouseUuid().orElse(null));
        if (tracker.hasActiveBaby(sender.m_142081_(), senderData.getSpouseUuid().orElse(null))) {
            if (((BabyTracker.Placement)((Object)pairing.locateBaby((Player)sender).getRight())).wasFound()) {
                this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.babyPresent"));
            } else {
                this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.babyLost"));
                pairing.reconstructBaby(sender);
            }
            return;
        }
        senderData.getSpouse().filter(e -> e instanceof Player).map(Player.class::cast).ifPresentOrElse(spouse -> {
            if (!this.procreateMap.containsKey((Object)spouse.m_142081_())) {
                this.procreateMap.put((Object)sender.m_142081_(), System.currentTimeMillis() + 10000L);
                this.infoMessage((Player)spouse, (BaseComponent)new TranslatableComponent("server.procreationRequest", new Object[]{sender.m_6302_()}));
            } else {
                this.successMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.procreationSuccessful"));
                this.successMessage((Player)spouse, (BaseComponent)new TranslatableComponent("server.procreationSuccessful"));
                pairing.addChild(s -> {
                    s.setGender(Gender.getRandom());
                    s.setOwner((Entity)sender);
                    spouse.m_36356_(s.createItem());
                });
            }
        }, () -> this.failMessage((Player)sender, (BaseComponent)new TranslatableComponent("server.spouseNotPresent")));
    }

    private void successMessage(Player player, BaseComponent message) {
        player.m_6352_((Component)message.m_130940_(ChatFormatting.GREEN), Util.f_137441_);
    }

    private void failMessage(Player player, BaseComponent message) {
        player.m_6352_((Component)message.m_130940_(ChatFormatting.RED), Util.f_137441_);
    }

    private void infoMessage(Player player, BaseComponent message) {
        player.m_6352_((Component)message.m_130940_(ChatFormatting.YELLOW), Util.f_137441_);
    }
}

