/*
 * Decompiled with CFR 0.152.
 */
package mca.server.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import mca.Config;
import mca.entity.EntitiesMCA;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.relationship.MarriageState;
import mca.entity.ai.relationship.family.FamilyTree;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.item.BabyItem;
import mca.server.world.data.Building;
import mca.server.world.data.PlayerSaveData;
import mca.server.world.data.Village;
import mca.server.world.data.VillageManager;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;

public class AdminCommand {
    private static final List<CompoundTag> storedVillagers = new ArrayList<CompoundTag>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mca-admin").then(AdminCommand.register("help", (Command<CommandSourceStack>)((Command)AdminCommand::displayHelp)))).then(AdminCommand.register("clearLoadedVillagers", (Command<CommandSourceStack>)((Command)AdminCommand::clearLoadedVillagers)))).then(AdminCommand.register("restoreClearedVillagers", (Command<CommandSourceStack>)((Command)AdminCommand::restoreClearedVillagers)))).then(AdminCommand.register("forceBuildingType").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).executes(AdminCommand::forceBuildingType)).executes(AdminCommand::clearForcedBuildingType))).then(AdminCommand.register("forceFullHearts", (Command<CommandSourceStack>)((Command)AdminCommand::forceFullHearts)))).then(AdminCommand.register("forceBabyGrowth", (Command<CommandSourceStack>)((Command)AdminCommand::forceBabyGrowth)))).then(AdminCommand.register("forceChildGrowth", (Command<CommandSourceStack>)((Command)AdminCommand::forceChildGrowth)))).then(AdminCommand.register("incrementHearts", (Command<CommandSourceStack>)((Command)AdminCommand::incrementHearts)))).then(AdminCommand.register("decrementHearts", (Command<CommandSourceStack>)((Command)AdminCommand::decrementHearts)))).then(AdminCommand.register("resetPlayerData", (Command<CommandSourceStack>)((Command)AdminCommand::resetPlayerData)))).then(AdminCommand.register("resetMarriage", (Command<CommandSourceStack>)((Command)AdminCommand::resetMarriage)))).then(AdminCommand.register("listVillages", (Command<CommandSourceStack>)((Command)AdminCommand::listVillages)))).then(AdminCommand.register("assumeNameDead").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(AdminCommand::assumeNameDead)))).then(AdminCommand.register("assumeUuidDead").then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).executes(AdminCommand::assumeUuidDead)))).then(AdminCommand.register("removeVillageWithId").then(Commands.m_82129_((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(AdminCommand::removeVillageWithId)))).then(AdminCommand.register("removeVillage").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(AdminCommand::removeVillage)))).then(AdminCommand.register("buildingProcessingRate").then(Commands.m_82129_((String)"cooldown", (ArgumentType)IntegerArgumentType.integer()).executes(AdminCommand::buildingProcessingRate)))).requires(serverCommandSource -> serverCommandSource.m_6761_(2)));
    }

    private static int listVillages(CommandContext<CommandSourceStack> ctx) {
        for (Village village : VillageManager.get(((CommandSourceStack)ctx.getSource()).m_81372_())) {
            BlockPos pos = village.getBox().m_162394_();
            AdminCommand.success(String.format("%d: %s with %d buildings and %d/%d villager(s)", village.getId(), village.getName(), village.getBuildings().size(), village.getPopulation(), village.getMaxPopulation()), ctx, new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.coordinates.tooltip")), new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.m_123341_() + " ~ " + pos.m_123343_()));
        }
        return 0;
    }

    private static int assumeNameDead(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        FamilyTree tree = FamilyTree.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        List<FamilyTreeNode> collect = tree.getAllWithName(name).filter(n -> !n.isDeceased()).toList();
        if (collect.isEmpty()) {
            AdminCommand.fail("Villager does not exist.", ctx, new Object[0]);
        } else if (collect.size() == 1) {
            collect.get(0).setDeceased(true);
            AdminCommand.assumeDead(ctx, collect.get(0).id());
            AdminCommand.success("Villager has been marked as deceased", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Villager not unique, use uuid!", ctx, new Object[0]);
        }
        return 0;
    }

    private static int assumeUuidDead(CommandContext<CommandSourceStack> ctx) {
        UUID uuid = UuidArgument.m_113853_(ctx, (String)"uuid");
        FamilyTree tree = FamilyTree.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        Optional<FamilyTreeNode> node = tree.getOrEmpty(uuid);
        if (node.isPresent()) {
            node.get().setDeceased(true);
            AdminCommand.assumeDead(ctx, uuid);
            AdminCommand.success("Villager has been marked as deceased", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Villager does not exist.", ctx, new Object[0]);
        }
        return 0;
    }

    private static void assumeDead(CommandContext<CommandSourceStack> ctx, UUID uuid) {
        for (Village village : VillageManager.get(((CommandSourceStack)ctx.getSource()).m_81372_())) {
            village.removeResident(uuid);
        }
        FamilyTree tree = FamilyTree.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        Optional<FamilyTreeNode> node = tree.getOrEmpty(uuid);
        node.filter(n -> n.spouse() != null).ifPresent(n -> n.updateMarriage(null, MarriageState.WIDOW));
        ((CommandSourceStack)ctx.getSource()).m_81372_().m_6907_().forEach(player -> {
            PlayerSaveData playerData = PlayerSaveData.get(((CommandSourceStack)ctx.getSource()).m_81372_(), player.m_142081_());
            if (playerData.getSpouseUuid().orElse(Util.f_137441_).equals(uuid)) {
                playerData.endMarriage(MarriageState.SINGLE);
            }
        });
    }

    private static int removeVillageWithId(CommandContext<CommandSourceStack> ctx) {
        int id = IntegerArgumentType.getInteger(ctx, (String)"id");
        if (VillageManager.get(((CommandSourceStack)ctx.getSource()).m_81372_()).removeVillage(id)) {
            AdminCommand.success("Village deleted.", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Village with this ID does not exist.", ctx, new Object[0]);
        }
        return 0;
    }

    private static int setBuildingType(CommandContext<CommandSourceStack> ctx, String type) throws CommandSyntaxException {
        ServerPlayer e = ((CommandSourceStack)ctx.getSource()).m_81375_();
        VillageManager villages = VillageManager.get(((CommandSourceStack)ctx.getSource()).m_81372_());
        Optional<Village> village = villages.findNearestVillage((Entity)e);
        Optional building = village.flatMap(arg_0 -> AdminCommand.lambda$setBuildingType$6((Player)e, arg_0));
        if (building.isPresent()) {
            if (((Building)building.get()).getType().equals(type)) {
                ((Building)building.get()).determineType();
            } else {
                ((Building)building.get()).setForcedType(type);
            }
        } else {
            AdminCommand.fail(new TranslatableComponent("blueprint.noBuilding").getString(), ctx, new Object[0]);
        }
        return 0;
    }

    private static int forceBuildingType(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return AdminCommand.setBuildingType(ctx, StringArgumentType.getString(ctx, (String)"type"));
    }

    private static int clearForcedBuildingType(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return AdminCommand.setBuildingType(ctx, null);
    }

    private static int removeVillage(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        List<Village> collect = VillageManager.get(((CommandSourceStack)ctx.getSource()).m_81372_()).findVillages(v -> v.getName().equals(name)).toList();
        if (collect.isEmpty()) {
            AdminCommand.fail("No village with this name exists.", ctx, new Object[0]);
        } else if (collect.size() > 1) {
            AdminCommand.success("Village deleted.", ctx, new Object[0]);
            AdminCommand.fail("No village with this name exists.", ctx, new Object[0]);
        } else if (VillageManager.get(((CommandSourceStack)ctx.getSource()).m_81372_()).removeVillage(collect.get(0).getId())) {
            AdminCommand.success("Village deleted.", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Unknown error.", ctx, new Object[0]);
        }
        return 0;
    }

    private static int buildingProcessingRate(CommandContext<CommandSourceStack> ctx) {
        int cooldown = IntegerArgumentType.getInteger(ctx, (String)"cooldown");
        VillageManager.get(((CommandSourceStack)ctx.getSource()).m_81372_()).setBuildingCooldown(cooldown);
        return 0;
    }

    private static int resetPlayerData(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        PlayerSaveData playerData = PlayerSaveData.get(((CommandSourceStack)ctx.getSource()).m_81372_(), player.m_142081_());
        playerData.reset();
        AdminCommand.success("Player data reset.", ctx, new Object[0]);
        return 0;
    }

    private static int resetMarriage(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        PlayerSaveData playerData = PlayerSaveData.get(((CommandSourceStack)ctx.getSource()).m_81372_(), player.m_142081_());
        playerData.endMarriage(MarriageState.SINGLE);
        AdminCommand.success("Marriage reset.", ctx, new Object[0]);
        return 0;
    }

    private static int decrementHearts(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        AdminCommand.getLoadedVillagers(ctx).forEach(arg_0 -> AdminCommand.lambda$decrementHearts$8((Player)player, arg_0));
        return 0;
    }

    private static int incrementHearts(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        AdminCommand.getLoadedVillagers(ctx).forEach(arg_0 -> AdminCommand.lambda$incrementHearts$9((Player)player, arg_0));
        return 0;
    }

    private static int forceChildGrowth(CommandContext<CommandSourceStack> ctx) {
        AdminCommand.getLoadedVillagers(ctx).forEach(v -> v.m_146762_(0));
        return 0;
    }

    private static int forceBabyGrowth(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ItemStack heldStack = player.m_21205_();
        if (heldStack.m_41720_() instanceof BabyItem) {
            heldStack.m_41784_().m_128405_("age", Config.getInstance().babyGrowUpTime);
            AdminCommand.success("Baby is old enough to place now.", ctx, new Object[0]);
        } else {
            AdminCommand.fail("Hold a baby first.", ctx, new Object[0]);
        }
        return 0;
    }

    private static int forceFullHearts(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        AdminCommand.getLoadedVillagers(ctx).forEach(arg_0 -> AdminCommand.lambda$forceFullHearts$11((Player)player, arg_0));
        return 0;
    }

    private static int restoreClearedVillagers(CommandContext<CommandSourceStack> ctx) {
        storedVillagers.forEach(tag -> EntityType.m_20642_((CompoundTag)tag, (Level)((CommandSourceStack)ctx.getSource()).m_81372_()).ifPresent(v -> ((CommandSourceStack)ctx.getSource()).m_81372_().m_7967_(v)));
        storedVillagers.clear();
        AdminCommand.success("Restored cleared villagers.", ctx, new Object[0]);
        return 0;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> register(String name, Command<CommandSourceStack> cmd) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)name).requires(cs -> cs.m_6761_(2))).executes(cmd);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> register(String name) {
        return Commands.m_82127_((String)name).requires(cs -> cs.m_6761_(2));
    }

    private static int clearLoadedVillagers(CommandContext<CommandSourceStack> ctx) {
        storedVillagers.clear();
        AdminCommand.getLoadedVillagers(ctx).forEach(v -> {
            CompoundTag tag = new CompoundTag();
            if (v.m_20086_(tag)) {
                storedVillagers.add(tag);
                v.m_146870_();
            }
        });
        AdminCommand.success("Removed loaded villagers.", ctx, new Object[0]);
        return 0;
    }

    private static Stream<VillagerEntityMCA> getLoadedVillagers(CommandContext<CommandSourceStack> ctx) {
        ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
        return Stream.concat(world.m_143280_((EntityTypeTest)EntitiesMCA.FEMALE_VILLAGER.get(), x -> true).stream(), world.m_143280_((EntityTypeTest)EntitiesMCA.MALE_VILLAGER.get(), x -> true).stream()).map(VillagerEntityMCA.class::cast);
    }

    private static void success(String message, CommandContext<CommandSourceStack> ctx, Object ... events) {
        MutableComponent data = new TextComponent(message).m_130940_(ChatFormatting.GREEN);
        for (Object evt : events) {
            if (evt instanceof ClickEvent) {
                ClickEvent clickEvent = (ClickEvent)evt;
                data.m_130938_(style -> style.m_131142_(clickEvent));
            }
            if (!(evt instanceof HoverEvent)) continue;
            HoverEvent hoverEvent = (HoverEvent)evt;
            data.m_130938_(style -> style.m_131144_(hoverEvent));
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)data, true);
    }

    private static void fail(String message, CommandContext<CommandSourceStack> ctx, Object ... events) {
        MutableComponent data = new TextComponent(message).m_130940_(ChatFormatting.RED);
        for (Object evt : events) {
            if (evt instanceof ClickEvent) {
                ClickEvent clickEvent = (ClickEvent)evt;
                data.m_130938_(style -> style.m_131142_(clickEvent));
            }
            if (!(evt instanceof HoverEvent)) continue;
            HoverEvent hoverEvent = (HoverEvent)evt;
            data.m_130938_(style -> style.m_131144_(hoverEvent));
        }
        ((CommandSourceStack)ctx.getSource()).m_81352_((Component)data);
    }

    private static int displayHelp(CommandContext<CommandSourceStack> ctx) {
        Entity player = ((CommandSourceStack)ctx.getSource()).m_81373_();
        if (player == null) {
            return 0;
        }
        AdminCommand.sendMessage(player, ChatFormatting.DARK_RED + "--- " + ChatFormatting.GOLD + "OP COMMANDS" + ChatFormatting.DARK_RED + " ---");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin forceBuildingType id " + ChatFormatting.GOLD + " - Force a building's type. " + ChatFormatting.RED + "(Must be a valid building type)");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin forceFullHearts " + ChatFormatting.GOLD + " - Force all hearts on all villagers.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin forceBabyGrowth " + ChatFormatting.GOLD + " - Force your baby to grow up.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin forceChildGrowth " + ChatFormatting.GOLD + " - Force nearby children to grow.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin clearLoadedVillagers " + ChatFormatting.GOLD + " - Clear all loaded villagers. " + ChatFormatting.RED + "(IRREVERSIBLE)");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin restoreClearedVillagers " + ChatFormatting.GOLD + " - Restores cleared villagers. ");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin listVillages " + ChatFormatting.GOLD + " - Prints a list of all villages.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin removeVillage id" + ChatFormatting.GOLD + " - Removed a village with given id.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin incrementHearts " + ChatFormatting.GOLD + " - Increase hearts by 10.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin decrementHearts " + ChatFormatting.GOLD + " - Decrease hearts by 10.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin cve" + ChatFormatting.GOLD + " - Remove all villager editors from the game.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin resetPlayerData " + ChatFormatting.GOLD + " - Resets hearts, marriage status etc.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin resetMarriage " + ChatFormatting.GOLD + " - Resets your marriage.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin listVillages " + ChatFormatting.GOLD + " - List all known villages.");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin removeVillage " + ChatFormatting.GOLD + " - Remove a given village.");
        AdminCommand.sendMessage(player, ChatFormatting.DARK_RED + "--- " + ChatFormatting.GOLD + "GLOBAL COMMANDS" + ChatFormatting.DARK_RED + " ---");
        AdminCommand.sendMessage(player, ChatFormatting.WHITE + " /mca-admin help " + ChatFormatting.GOLD + " - Shows this list of commands.");
        return 0;
    }

    private static void sendMessage(Entity commandSender, String message) {
        commandSender.m_6352_((Component)new TextComponent(ChatFormatting.GOLD + "[MCA] " + ChatFormatting.RESET + message), Util.f_137441_);
    }

    private static /* synthetic */ void lambda$forceFullHearts$11(Player player, VillagerEntityMCA v) {
        v.getVillagerBrain().getMemoriesForPlayer(player).setHearts(1000);
    }

    private static /* synthetic */ void lambda$incrementHearts$9(Player player, VillagerEntityMCA v) {
        v.getVillagerBrain().getMemoriesForPlayer(player).modHearts(10);
    }

    private static /* synthetic */ void lambda$decrementHearts$8(Player player, VillagerEntityMCA v) {
        v.getVillagerBrain().getMemoriesForPlayer(player).modHearts(-10);
    }

    private static /* synthetic */ Optional lambda$setBuildingType$6(Player e, Village v) {
        return v.getBuildings().values().stream().filter(b -> b.containsPos((Vec3i)e.m_142538_())).findAny();
    }
}

