/*
 * Decompiled with CFR 0.152.
 */
package mca.server.world.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mca.entity.ai.relationship.Gender;
import mca.item.ItemsMCA;
import mca.util.InventoryUtils;
import mca.util.NbtHelper;
import mca.util.WorldUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.commons.lang3.tuple.Pair;

public class BabyTracker
extends SavedData {
    private final Map<Key, Pairing> pairings = new HashMap<Key, Pairing>();

    public static BabyTracker get(ServerLevel world) {
        return WorldUtils.loadData(world.m_142572_().m_129783_(), nbt -> new BabyTracker(world, (CompoundTag)nbt), BabyTracker::new, "mca_baby_tracker");
    }

    BabyTracker(ServerLevel world) {
    }

    BabyTracker(ServerLevel world, CompoundTag nbt) {
        nbt.m_128437_("pairings", 10).forEach(element -> {
            Pairing pairing = new Pairing((CompoundTag)element);
            this.pairings.put(pairing.key, pairing);
        });
    }

    public Optional<MutableChildSaveState> getSaveState(UUID id) {
        return this.pairings.values().stream().flatMap(pairing -> pairing.children.stream().filter(s -> s.id.equals(id))).findFirst();
    }

    public boolean hasActiveBaby(UUID mother, UUID father) {
        return false;
    }

    public Pairing getPairing(UUID mother, UUID father) {
        return this.getPairing(new Key(mother, father));
    }

    public Optional<Pairing> getPairingOrEmpty(UUID mother, UUID father) {
        return Optional.ofNullable(this.pairings.get(new Key(mother, father)));
    }

    public Pairing getPairing(ChildSaveState state) {
        return this.getPairing(state.key);
    }

    private Pairing getPairing(Key key) {
        return this.pairings.computeIfAbsent(key, x$0 -> new Pairing((Key)x$0));
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        this.pairings.values().forEach(pairing -> list.add((Object)pairing.toNbt()));
        nbt.m_128365_("pairings", (Tag)list);
        return nbt;
    }

    public static Optional<MutableChildSaveState> getState(ItemStack stack, ServerLevel world) {
        if (!BabyTracker.hasState(stack)) {
            return Optional.empty();
        }
        ChildSaveState state = new ChildSaveState(stack.m_41737_("childData"));
        return BabyTracker.get((ServerLevel)world).getPairing((ChildSaveState)state).children.stream().filter(s -> s.id.equals(state.id)).findAny();
    }

    public static Optional<ChildSaveState> getState(ItemStack stack) {
        return BabyTracker.hasState(stack) ? Optional.of(new ChildSaveState(stack.m_41737_("childData"))) : Optional.empty();
    }

    public static Optional<UUID> getStateId(ItemStack stack) {
        return BabyTracker.hasState(stack) ? Optional.of(stack.m_41737_("childData").m_128342_("id")) : Optional.empty();
    }

    public static boolean hasState(ItemStack stack) {
        return stack.m_41782_() && !stack.m_41783_().m_128471_("invalidated") && stack.m_41783_().m_128425_("childData", 10) && stack.m_41737_("childData").m_128403_("id");
    }

    public static void invalidate(ItemStack stack) {
        stack.m_41749_("childData");
        stack.m_41784_().m_128379_("invalidated", true);
    }

    private static class Key
    implements Comparable<Key> {
        private final Set<UUID> parents = new HashSet<UUID>();

        public Key(UUID mother, UUID father) {
            this.parents.add(mother);
            this.parents.add(father);
        }

        public Key(ListTag nbt) {
            nbt.forEach(i -> this.parents.add(UUID.fromString(i.m_7916_())));
        }

        public ListTag toNbt() {
            ListTag nbt = new ListTag();
            this.parents.forEach(parent -> nbt.add((Object)StringTag.m_129297_((String)parent.toString())));
            return nbt;
        }

        @Override
        public int compareTo(Key o) {
            return this.equals(o) ? 0 : 1;
        }

        private boolean equals(Key o) {
            return o != null && o.parents.equals(this.parents);
        }

        public boolean equals(Object o) {
            return o instanceof Key && this.equals((Key)o);
        }

        public int hashCode() {
            return this.parents.hashCode();
        }
    }

    public final class Pairing {
        private final Key key;
        private final List<MutableChildSaveState> children;

        public Pairing(Key key) {
            this.key = key;
            this.children = new ArrayList<MutableChildSaveState>();
            BabyTracker.this.m_77762_();
        }

        public Pairing(CompoundTag tag) {
            this.key = new Key(tag.m_128437_("key", 8));
            this.children = NbtHelper.toList((Tag)tag.m_128437_("children", 10), c -> new MutableChildSaveState((CompoundTag)c));
        }

        public int getChildCount() {
            return this.children.size();
        }

        public void addChild(Consumer<MutableChildSaveState> factory) {
            MutableChildSaveState state = new MutableChildSaveState(this.key);
            factory.accept(state);
            this.children.add(state);
            BabyTracker.this.m_77762_();
        }

        public void removeChild(ChildSaveState state) {
            this.children.removeIf(o -> o.id.equals(state.id));
        }

        public List<ChildSaveState> getChildren() {
            return new ArrayList<ChildSaveState>(this.children);
        }

        public Pair<ItemStack, Placement> locateBaby(Player player) {
            int slot = InventoryUtils.getFirstSlotContainingItem((Container)player.m_150109_(), stack -> BabyTracker.getState(stack).filter(state -> state.key.equals(this.key)).isPresent());
            if (slot >= 0) {
                return Pair.of((Object)player.m_150109_().m_8020_(slot), (Object)((Object)Placement.INVENTORY));
            }
            slot = InventoryUtils.getFirstSlotContainingItem((Container)player.m_36327_(), stack -> BabyTracker.getState(stack).filter(state -> state.key.equals(this.key)).isPresent());
            if (slot >= 0) {
                return Pair.of((Object)player.m_36327_().m_8020_(slot), (Object)((Object)Placement.ENDER_CHEST));
            }
            return Pair.of((Object)ItemStack.f_41583_, (Object)((Object)Placement.MISSING));
        }

        public CompoundTag toNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("key", (Tag)this.key.toNbt());
            tag.m_128365_("children", (Tag)NbtHelper.fromList(this.children, child -> child.writeToNbt(new CompoundTag())));
            return tag;
        }

        public void reconstructBaby(ServerPlayer player) {
            this.getChildren().forEach(c -> {
                ItemStack stack = new ItemStack(c.getGender() == Gender.MALE ? (ItemLike)ItemsMCA.BABY_BOY.get() : (ItemLike)ItemsMCA.BABY_GIRL.get());
                c.writeToNbt(stack.m_41698_("childData"));
                player.m_150109_().m_36054_(stack);
            });
        }
    }

    public static class ChildSaveState {
        final UUID id;
        protected Gender gender;
        protected boolean infected;
        protected long seed;
        protected Optional<String> name = Optional.empty();
        private final Key key;
        protected Optional<Pair<UUID, String>> owner = Optional.empty();

        ChildSaveState(Key key) {
            this.id = UUID.randomUUID();
            this.key = key;
        }

        public ChildSaveState(CompoundTag tag) {
            this.id = tag.m_128342_("id");
            this.gender = Gender.byName(tag.m_128461_("gender"));
            this.infected = tag.m_128471_("infected");
            this.name = tag.m_128441_("name") ? Optional.of(tag.m_128461_("name")) : Optional.empty();
            this.seed = tag.m_128454_("seed");
            this.key = new Key(tag.m_128437_("key", 8));
        }

        public UUID getId() {
            return this.id;
        }

        public Stream<UUID> getParents() {
            return this.key.parents.stream();
        }

        public boolean isInfected() {
            return this.infected;
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Optional<Pair<UUID, String>> getOwner() {
            return this.owner;
        }

        public long getSeed() {
            return this.seed;
        }

        public Gender getGender() {
            return this.gender;
        }

        public CompoundTag writeToNbt(CompoundTag tag) {
            tag.m_128362_("id", this.id);
            tag.m_128359_("gender", this.gender.getStrName());
            tag.m_128379_("infected", this.infected);
            tag.m_128365_("key", (Tag)this.key.toNbt());
            tag.m_128356_("seed", this.seed);
            this.name.ifPresent(n -> tag.m_128359_("name", n));
            return tag;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        private boolean equals(ChildSaveState o) {
            return o == this || o != null && o.id.equals(this.id);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ChildSaveState && this.equals((ChildSaveState)o);
        }
    }

    public class MutableChildSaveState
    extends ChildSaveState {
        MutableChildSaveState(Key key) {
            super(key);
        }

        public MutableChildSaveState(CompoundTag tag) {
            super(tag);
        }

        public MutableChildSaveState setGender(Gender gender) {
            this.gender = gender;
            BabyTracker.this.m_77762_();
            return this;
        }

        public MutableChildSaveState setInfected(boolean infected) {
            this.infected = infected;
            BabyTracker.this.m_77762_();
            return this;
        }

        public MutableChildSaveState setName(String name) {
            this.name = Optional.ofNullable(name);
            BabyTracker.this.m_77762_();
            return this;
        }

        public MutableChildSaveState setOwner(Entity entity) {
            this.owner = Optional.of(Pair.of((Object)entity.m_142081_(), (Object)entity.m_7755_().getString()));
            BabyTracker.this.m_77762_();
            return this;
        }

        public MutableChildSaveState setSeed(long seed) {
            this.seed = seed;
            BabyTracker.this.m_77762_();
            return this;
        }

        public ItemStack createItem() {
            return this.writeToItem(((Item)(this.gender.binary() == Gender.MALE ? ItemsMCA.BABY_BOY : ItemsMCA.BABY_GIRL).get()).m_7968_());
        }

        public ItemStack writeToItem(ItemStack stack) {
            this.writeToNbt(stack.m_41698_("childData"));
            return stack;
        }
    }

    public static enum Placement {
        INVENTORY,
        ENDER_CHEST,
        MISSING;


        public boolean wasFound() {
            return this != MISSING;
        }
    }
}

