/*
 * Decompiled with CFR 0.152.
 */
package mca.server.world.data;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import mca.Config;
import mca.advancement.criterion.CriterionMCA;
import mca.cobalt.network.NetworkHandler;
import mca.entity.EntitiesMCA;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.relationship.EntityRelationship;
import mca.entity.ai.relationship.MarriageState;
import mca.entity.ai.relationship.RelationshipType;
import mca.entity.ai.relationship.family.FamilyTree;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.item.ItemsMCA;
import mca.network.s2c.ShowToastRequest;
import mca.resources.API;
import mca.resources.Rank;
import mca.resources.Tasks;
import mca.server.world.data.Village;
import mca.server.world.data.VillageManager;
import mca.util.NbtHelper;
import mca.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSaveData
extends SavedData
implements EntityRelationship {
    private final UUID playerId;
    private Optional<UUID> spouseUUID = Optional.empty();
    private Optional<Component> spouseName = Optional.empty();
    private MarriageState marriageState;
    private final ServerLevel world;
    private Optional<Integer> lastSeenVillage = Optional.empty();
    private boolean entityDataSet;
    private CompoundTag entityData;
    private final List<CompoundTag> inbox = new LinkedList<CompoundTag>();

    public static PlayerSaveData get(ServerLevel world, UUID uuid) {
        return WorldUtils.loadData(world.m_142572_().m_129783_(), nbt -> new PlayerSaveData(world, (CompoundTag)nbt), w -> new PlayerSaveData((ServerLevel)w, uuid), "mca_player_" + uuid.toString());
    }

    PlayerSaveData(ServerLevel world, UUID playerId) {
        assert (playerId != null);
        this.world = world;
        this.playerId = playerId;
        this.marriageState = MarriageState.SINGLE;
        this.resetEntityData();
    }

    PlayerSaveData(ServerLevel world, CompoundTag nbt) {
        this.world = world;
        this.playerId = nbt.m_128342_("playerId");
        this.lastSeenVillage = nbt.m_128425_("lastSeenVillage", 3) ? Optional.of(nbt.m_128451_("lastSeenVillage")) : Optional.empty();
        this.spouseUUID = nbt.m_128441_("spouseUUID") ? Optional.of(nbt.m_128342_("spouseUUID")) : Optional.empty();
        this.spouseName = nbt.m_128441_("spouseName") ? Optional.of(new TextComponent(nbt.m_128461_("spouseName"))) : Optional.empty();
        this.entityDataSet = nbt.m_128441_("entityDataSet") && nbt.m_128471_("entityDataSet");
        this.marriageState = MarriageState.byId(nbt.m_128451_("marriageState"));
        if (nbt.m_128441_("entityData")) {
            this.entityData = nbt.m_128469_("entityData");
        } else {
            this.resetEntityData();
        }
        ListTag inbox = nbt.m_128437_("inbox", 10);
        if (inbox != null) {
            this.inbox.clear();
            for (int i = 0; i < inbox.size(); ++i) {
                this.inbox.add(inbox.m_128728_(i));
            }
        }
    }

    private void resetEntityData() {
        this.entityData = new CompoundTag();
        VillagerEntityMCA villager = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).m_20615_((Level)this.world);
        assert (villager != null);
        villager.initializeSkin();
        villager.getGenetics().randomize();
        villager.getTraits().randomize();
        villager.getVillagerBrain().randomize();
        villager.m_7380_(this.entityData);
    }

    public boolean isEntityDataSet() {
        return this.entityDataSet;
    }

    public CompoundTag getEntityData() {
        return this.entityData;
    }

    public void setEntityDataSet(boolean entityDataSet) {
        this.entityDataSet = entityDataSet;
    }

    public void setEntityData(CompoundTag entityData) {
        this.entityData = entityData;
    }

    @Override
    public void onTragedy(DamageSource cause, @Nullable BlockPos burialSite, RelationshipType type, Entity victim) {
        if (this.playerId == null) {
            return;
        }
        EntityRelationship.super.onTragedy(cause, burialSite, type, victim);
        if (victim instanceof VillagerEntityMCA) {
            VillagerEntityMCA victimVillager = (VillagerEntityMCA)victim;
            this.sendLetterOfCondolence((ServerPlayer)this.world.m_8791_(this.playerId), victimVillager.m_7755_().getString(), victimVillager.getResidency().getHomeVillage().map(Village::getName).orElse(API.getVillagePool().pickVillageName("village")));
        }
    }

    public void updateLastSeenVillage(VillageManager manager, ServerPlayer self) {
        Optional<Village> prevVillage = this.getLastSeenVillage(manager);
        Optional<Village> nextVillage = prevVillage.filter(v -> v.isWithinBorder((Entity)self)).or(() -> manager.findNearestVillage((Entity)self));
        this.setLastSeenVillage(self, prevVillage.orElse(null), nextVillage.orElse(null));
        if (nextVillage.isPresent()) {
            Rank rank = Tasks.getRank(nextVillage.get(), self);
            CriterionMCA.RANK.trigger(self, rank);
        }
    }

    public void setLastSeenVillage(ServerPlayer self, Village oldVillage, @Nullable Village newVillage) {
        this.lastSeenVillage = Optional.ofNullable(newVillage).map(Village::getId);
        this.m_77762_();
        if (oldVillage != newVillage) {
            if (oldVillage != null) {
                this.onLeave((Player)self, oldVillage);
            }
            if (newVillage != null) {
                this.onEnter((Player)self, newVillage);
            }
        }
    }

    public Optional<Village> getLastSeenVillage(VillageManager manager) {
        return this.lastSeenVillage.flatMap(manager::getOrEmpty);
    }

    public Optional<Integer> getLastSeenVillageId() {
        return this.lastSeenVillage;
    }

    protected void onLeave(Player self, Village village) {
        if (Config.getInstance().enterVillageNotification) {
            self.m_5661_((Component)new TranslatableComponent("gui.village.left", new Object[]{village.getName()}).m_130940_(ChatFormatting.GOLD), true);
        }
    }

    protected void onEnter(Player self, Village village) {
        if (Config.getInstance().enterVillageNotification) {
            self.m_5661_((Component)new TranslatableComponent("gui.village.welcome", new Object[]{village.getName()}).m_130940_(ChatFormatting.GOLD), true);
        }
        village.deliverTaxes(this.world);
    }

    @Override
    public Optional<UUID> getSpouseUuid() {
        return this.spouseUUID;
    }

    @Override
    public void marry(Entity spouse) {
        MarriageState marriageState = spouse instanceof Player ? MarriageState.MARRIED_TO_PLAYER : MarriageState.MARRIED_TO_VILLAGER;
        this.spouseUUID = Optional.of(spouse.m_142081_());
        this.spouseName = Optional.of(spouse.m_7755_());
        this.marriageState = marriageState;
        this.getFamilyEntry().updateMarriage(spouse, marriageState);
        this.m_77762_();
    }

    @Override
    public void endMarriage(MarriageState newState) {
        this.spouseUUID = Optional.empty();
        this.spouseName = Optional.empty();
        this.marriageState = newState;
        this.getFamilyEntry().setMarriageState(newState);
        this.m_77762_();
    }

    @Override
    public MarriageState getMarriageState() {
        return this.marriageState;
    }

    @Override
    public Optional<Component> getSpouseName() {
        return this.isMarried() ? this.spouseName : Optional.empty();
    }

    @Override
    public FamilyTree getFamilyTree() {
        return FamilyTree.get(this.world);
    }

    @Override
    public Stream<Entity> getFamily(int parents, int children) {
        return this.getFamilyEntry().getRelatives(parents, children).map(arg_0 -> ((ServerLevel)this.world).m_8791_(arg_0)).filter(Objects::nonNull).filter(e -> !e.m_142081_().equals(this.playerId));
    }

    @Override
    @NotNull
    public FamilyTreeNode getFamilyEntry() {
        return this.getFamilyTree().getOrCreate(Objects.requireNonNull(this.world.m_8791_(this.playerId)));
    }

    @Override
    public Stream<Entity> getParents() {
        return this.getFamilyEntry().streamParents().map(arg_0 -> ((ServerLevel)this.world).m_8791_(arg_0)).filter(Objects::nonNull);
    }

    @Override
    public Stream<Entity> getSiblings() {
        return this.getFamilyEntry().siblings().stream().map(arg_0 -> ((ServerLevel)this.world).m_8791_(arg_0)).filter(Objects::nonNull).filter(e -> !e.m_142081_().equals(this.playerId));
    }

    @Override
    public Optional<Entity> getSpouse() {
        return this.spouseUUID.map(arg_0 -> ((ServerLevel)this.world).m_8791_(arg_0));
    }

    public void reset() {
        this.endMarriage(MarriageState.SINGLE);
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128362_("playerId", this.playerId);
        this.spouseUUID.ifPresent(id -> nbt.m_128362_("spouseUUID", id));
        this.lastSeenVillage.ifPresent(id -> nbt.m_128405_("lastSeenVillage", id.intValue()));
        this.spouseName.ifPresent(n -> nbt.m_128359_("spouseName", n.getString()));
        nbt.m_128365_("entityData", (Tag)this.entityData);
        nbt.m_128379_("entityDataSet", this.entityDataSet);
        nbt.m_128365_("inbox", (Tag)NbtHelper.fromList(this.inbox, v -> v));
        nbt.m_128405_("marriageState", this.marriageState.ordinal());
        return nbt;
    }

    public void sendMail(CompoundTag nbt) {
        this.inbox.add(nbt);
        this.m_77762_();
    }

    public boolean hasMail() {
        return this.inbox.size() > 0;
    }

    public ItemStack getMail() {
        if (this.hasMail()) {
            CompoundTag nbt = this.inbox.remove(0);
            ItemStack stack = new ItemStack((ItemLike)ItemsMCA.LETTER.get(), 1);
            stack.m_41751_(nbt);
            return stack;
        }
        return null;
    }

    public void sendLetterOfCondolence(ServerPlayer player, String name, String village) {
        ListTag l = new ListTag();
        l.add(0, (Tag)StringTag.m_129297_((String)String.format("{ \"translate\": \"mca.letter.condolence\", \"with\": [\"%s\", \"%s\", \"%s\"] }", this.getFamilyEntry().getName(), name, village)));
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("pages", (Tag)l);
        this.sendMail(nbt);
        this.showMailNotification(player);
    }

    public void showMailNotification(ServerPlayer player) {
        NetworkHandler.sendToPlayer(new ShowToastRequest("server.mail.title", "server.mail.description"), player);
    }
}

