/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.mrscauthd.beyond_earth.compats.CompatibleManager;
import net.mrscauthd.beyond_earth.config.Config;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.PlanetSelectionGuiNetworkHandler;
import net.mrscauthd.beyond_earth.keybinds.KeyBindings;
import net.mrscauthd.beyond_earth.machines.tile.OxygenBubbleDistributorBlockEntity;
import net.mrscauthd.beyond_earth.registries.BlockEntitiesRegistry;
import net.mrscauthd.beyond_earth.registries.BlocksRegistry;
import net.mrscauthd.beyond_earth.registries.EffectsRegistry;
import net.mrscauthd.beyond_earth.registries.EntitiesRegistry;
import net.mrscauthd.beyond_earth.registries.FeatureRegistry;
import net.mrscauthd.beyond_earth.registries.FluidsRegistry;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;
import net.mrscauthd.beyond_earth.registries.PaintingsRegistry;
import net.mrscauthd.beyond_earth.registries.ParticlesRegistry;
import net.mrscauthd.beyond_earth.registries.RecipeSerializersRegistry;
import net.mrscauthd.beyond_earth.registries.RocketPartsRegistry;
import net.mrscauthd.beyond_earth.registries.ScreensRegistry;
import net.mrscauthd.beyond_earth.registries.SensorsRegistry;
import net.mrscauthd.beyond_earth.registries.SoundsRegistry;
import net.mrscauthd.beyond_earth.registries.StructuresRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="beyond_earth")
public class BeyondEarthMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "beyond_earth";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("beyond_earth", "beyond_earth"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID;

    public BeyondEarthMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, "beyond_earth-common.toml");
        ItemsRegistry.ITEMS.register(bus);
        BlocksRegistry.BLOCKS.register(bus);
        FluidsRegistry.FLUIDS.register(bus);
        EntitiesRegistry.ENTITIES.register(bus);
        BlockEntitiesRegistry.BLOCK_ENTITIES.register(bus);
        RocketPartsRegistry.ROCKET_PARTS.register(bus);
        PaintingsRegistry.PAINTINGS.register(bus);
        SensorsRegistry.SENSOR.register(bus);
        RecipeSerializersRegistry.RECIPE_SERIALIZERS.register(bus);
        SoundsRegistry.SOUNDS.register(bus);
        EffectsRegistry.EFFECTS.register(bus);
        ParticlesRegistry.PARTICLES.register(bus);
        ScreensRegistry.SCREENS.register(bus);
        StructuresRegistry.STRUCTURES.register(bus);
        FeatureRegistry.FEATURES.register(bus);
        FeatureRegistry.CONFIGURED_FEATURES.register(bus);
        FeatureRegistry.PLACED_FEATURES.register(bus);
        KeyBindings.registerMessages();
        BeyondEarthMod.addNetworkMessage(OxygenBubbleDistributorBlockEntity.ChangeRangeMessage.class, OxygenBubbleDistributorBlockEntity.ChangeRangeMessage::encode, OxygenBubbleDistributorBlockEntity.ChangeRangeMessage::decode, OxygenBubbleDistributorBlockEntity.ChangeRangeMessage::handle);
        BeyondEarthMod.addNetworkMessage(OxygenBubbleDistributorBlockEntity.ChangeWorkingAreaVisibleMessage.class, OxygenBubbleDistributorBlockEntity.ChangeWorkingAreaVisibleMessage::encode, OxygenBubbleDistributorBlockEntity.ChangeWorkingAreaVisibleMessage::decode, OxygenBubbleDistributorBlockEntity.ChangeWorkingAreaVisibleMessage::handle);
        BeyondEarthMod.addNetworkMessage(PlanetSelectionGuiNetworkHandler.class, PlanetSelectionGuiNetworkHandler::encode, PlanetSelectionGuiNetworkHandler::decode, PlanetSelectionGuiNetworkHandler::handle);
        CompatibleManager.visit();
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }
}

