/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.entities;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.mrscauthd.beyond_earth.blocks.RocketLaunchPad;
import net.mrscauthd.beyond_earth.entities.RocketTier1Entity;
import net.mrscauthd.beyond_earth.entities.VehicleEntity;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.events.forge.PlayerEnterPlanetSelectionGuiEvent;

public abstract class IRocketEntity
extends VehicleEntity {
    public double ROCKET_SPEED;
    public double ar = 0.0;
    public double ay = 0.0;
    public double ap = 0.0;
    public static final EntityDataAccessor<Boolean> ROCKET_START = SynchedEntityData.m_135353_(RocketTier1Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> BUCKETS = SynchedEntityData.m_135353_(RocketTier1Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.m_135353_(RocketTier1Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> START_TIMER = SynchedEntityData.m_135353_(RocketTier1Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory});

    public IRocketEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.f_19804_.m_135372_(ROCKET_START, (Object)false);
        this.f_19804_.m_135372_(BUCKETS, (Object)0);
        this.f_19804_.m_135372_(FUEL, (Object)0);
        this.f_19804_.m_135372_(START_TIMER, (Object)0);
    }

    protected void setRocketSpeed(double speed) {
        this.ROCKET_SPEED = speed;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_7334_(Entity p_21294_) {
    }

    public void m_6074_() {
        this.dropEquipment();
        this.spawnRocketItem();
        if (!this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_6469_(DamageSource source, float p_21017_) {
        Entity sourceEntity = source.m_7639_();
        if (!source.m_19360_() && sourceEntity != null && sourceEntity.m_6047_() && !this.m_20160_()) {
            this.spawnRocketItem();
            this.dropEquipment();
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    protected abstract void spawnRocketItem();

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().get();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
        compound.m_128379_("rocket_start", ((Boolean)this.m_20088_().m_135370_(ROCKET_START)).booleanValue());
        compound.m_128405_("buckets", ((Integer)this.m_20088_().m_135370_(BUCKETS)).intValue());
        compound.m_128405_("fuel", ((Integer)this.m_20088_().m_135370_(FUEL)).intValue());
        compound.m_128405_("start_timer", ((Integer)this.m_20088_().m_135370_(START_TIMER)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            this.inventory.deserializeNBT((CompoundTag)inventoryCustom);
        }
        this.m_20088_().m_135381_(ROCKET_START, (Object)compound.m_128471_("rocket_start"));
        this.m_20088_().m_135381_(BUCKETS, (Object)compound.m_128451_("buckets"));
        this.m_20088_().m_135381_(FUEL, (Object)compound.m_128451_("fuel"));
        this.m_20088_().m_135381_(START_TIMER, (Object)compound.m_128451_("start_timer"));
    }

    public abstract void particleSpawn();

    public abstract void fillUpRocket();

    public boolean doesDrop(BlockState state, BlockPos pos) {
        if (this.m_20096_() || this.m_20069_()) {
            BlockState state2 = this.f_19853_.m_8055_(new BlockPos(Math.floor(this.m_20185_()), this.m_20186_() - 0.2, Math.floor(this.m_20189_())));
            if (!this.f_19853_.m_46859_(pos) && (state2.m_60734_() instanceof RocketLaunchPad && !((Boolean)state2.m_61143_((Property)RocketLaunchPad.STAGE)).booleanValue() || !(state.m_60734_() instanceof RocketLaunchPad))) {
                this.dropEquipment();
                this.spawnRocketItem();
                if (!this.f_19853_.f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                return true;
            }
        }
        return false;
    }

    protected void checkOnBlocks() {
        AABB aabb = this.m_142469_();
        BlockPos blockPos1 = new BlockPos(aabb.f_82288_ + 0.001, aabb.f_82289_ - 0.2 + 0.001, aabb.f_82290_ + 0.001);
        BlockPos blockPos2 = new BlockPos(aabb.f_82291_ - 0.001, aabb.f_82289_ - 0.001, aabb.f_82293_ - 0.001);
        if (this.f_19853_.m_46832_(blockPos1, blockPos2)) {
            for (int i = blockPos1.m_123341_(); i <= blockPos2.m_123341_(); ++i) {
                for (int j = blockPos1.m_123342_(); j <= blockPos2.m_123342_(); ++j) {
                    for (int k = blockPos1.m_123343_(); k <= blockPos2.m_123343_(); ++k) {
                        BlockPos pos = new BlockPos(i, j, k);
                        BlockState state = this.f_19853_.m_8055_(pos);
                        if (!this.doesDrop(state, pos)) continue;
                        return;
                    }
                }
            }
        }
    }

    public void rocketAnimation() {
        this.ar += 1.0;
        if (this.ar == 1.0) {
            this.ay += 0.006;
            this.ap += 0.006;
        } else if (this.ar == 2.0) {
            this.ar = 0.0;
            this.ay = 0.0;
            this.ap = 0.0;
        }
    }

    public void startTimerAndFlyMovement() {
        if ((Integer)this.f_19804_.m_135370_(START_TIMER) < 200) {
            this.f_19804_.m_135381_(START_TIMER, (Object)((Integer)this.f_19804_.m_135370_(START_TIMER) + 1));
        }
        if ((Integer)this.f_19804_.m_135370_(START_TIMER) == 200) {
            if (this.m_20184_().f_82480_ < this.ROCKET_SPEED - 0.1) {
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.1, this.m_20184_().f_82481_);
            } else {
                this.m_20334_(this.m_20184_().f_82479_, this.ROCKET_SPEED, this.m_20184_().f_82481_);
            }
        }
    }

    public void openPlanetSelectionGui() {
        if (this.m_20186_() > 600.0 && !this.m_20197_().isEmpty()) {
            if (this.m_20197_().get(0) instanceof Player) {
                Player pass = (Player)this.m_20197_().get(0);
                if (pass.f_36096_ != null) {
                    pass.m_6915_();
                }
                pass.getPersistentData().m_128379_("beyond_earth:planet_selection_gui_open", true);
                pass.getPersistentData().m_128359_("beyond_earth:rocket_type", this.m_6095_().toString());
                pass.getPersistentData().m_128359_("beyond_earth:slot0", this.getInventory().getStackInSlot(0).m_41720_().getRegistryName().toString());
                pass.m_20242_(true);
                MinecraftForge.EVENT_BUS.post((Event)new PlayerEnterPlanetSelectionGuiEvent(pass, this));
                if (!this.f_19853_.f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        } else if (this.m_20186_() > 600.0 && this.m_20197_().isEmpty() && !this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void rocketExplosion() {
        if ((Integer)this.f_19804_.m_135370_(START_TIMER) == 200 && this.m_20184_().f_82480_ < -0.07 && !this.f_19853_.f_46443_) {
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_142469_().f_82292_, this.m_20189_(), 10.0f, true, Explosion.BlockInteraction.BREAK);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void burnEntities() {
        if ((Integer)this.f_19804_.m_135370_(START_TIMER) == 200) {
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() - 2.0, this.m_20189_()), (double)2.0, (double)2.0, (double)2.0);
            List entities = this.m_20193_().m_45976_(LivingEntity.class, aabb);
            for (LivingEntity entity : entities) {
                if (Methods.netheriteSpaceSuitCheck(entity)) continue;
                entity.m_20254_(15);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.checkOnBlocks();
        this.fillUpRocket();
        this.rocketExplosion();
        this.burnEntities();
        if (((Boolean)this.f_19804_.m_135370_(ROCKET_START)).booleanValue()) {
            this.particleSpawn();
            this.rocketAnimation();
            this.startTimerAndFlyMovement();
            this.openPlanetSelectionGui();
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Vec3[] avector3d = new Vec3[]{IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)livingEntity.m_146908_()), IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 22.5f)), IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 22.5f)), IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 45.0f)), IRocketEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.m_142469_().f_82292_;
        double d1 = this.m_142469_().f_82289_ - 0.5;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Vec3 vector3d : avector3d) {
            blockpos$mutable.m_122169_(this.m_20185_() + vector3d.f_82479_, d0, this.m_20189_() + vector3d.f_82481_);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.m_7949_());
                blockpos$mutable.m_122173_(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double d3;
            if (this.f_19853_.m_6425_(blockpos).m_205070_(FluidTags.f_13132_) || !DismountHelper.m_38439_((double)(d3 = this.f_19853_.m_45573_(blockpos)))) continue;
            Vec3 vector3d1 = Vec3.m_82514_((Vec3i)blockpos, (double)d3);
            for (Pose pose : livingEntity.m_7431_()) {
                if (!DismountHelper.m_38439_((double)this.f_19853_.m_45573_(blockpos))) continue;
                livingEntity.m_20124_(pose);
                return vector3d1;
            }
        }
        return new Vec3(this.m_20185_(), this.m_142469_().f_82292_, this.m_20189_());
    }
}

