/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.entities;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.mrscauthd.beyond_earth.entities.VehicleEntity;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.fluids.FluidUtil2;
import net.mrscauthd.beyond_earth.guis.screens.rover.RoverGui;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;
import net.mrscauthd.beyond_earth.registries.TagsRegistry;

public class RoverEntity
extends VehicleEntity {
    private double speed = 0.0;
    public float flyingSpeed = 0.02f;
    public float animationSpeedOld;
    public float animationSpeed;
    public float animationPosition;
    private float FUEL_USE_TICK = 8.0f;
    private float FUEL_TIMER = 0.0f;
    public static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.m_135353_(RoverEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> FORWARD = SynchedEntityData.m_135353_(RoverEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int FUEL_BUCKETS = 3;
    private final ItemStackHandler inventory = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory});

    public RoverEntity(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.f_19804_.m_135372_(FUEL, (Object)0);
        this.f_19804_.m_135372_(FORWARD, (Object)false);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_7334_(Entity p_21294_) {
    }

    @Deprecated
    public boolean canBeRiddenInWater() {
        return true;
    }

    public boolean m_6146_() {
        return true;
    }

    public double m_6048_() {
        return super.m_6048_() - 0.15;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7340_(Entity p_20320_) {
        this.applyYawToEntity(p_20320_);
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Vec3[] avector3d = new Vec3[]{RoverEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)livingEntity.m_146908_()), RoverEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 22.5f)), RoverEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 22.5f)), RoverEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() - 45.0f)), RoverEntity.m_19903_((double)this.m_20205_(), (double)livingEntity.m_20205_(), (float)(livingEntity.m_146908_() + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.m_142469_().f_82292_;
        double d1 = this.m_142469_().f_82289_ - 0.5;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Vec3 vector3d : avector3d) {
            blockpos$mutable.m_122169_(this.m_20185_() + vector3d.f_82479_, d0, this.m_20189_() + vector3d.f_82481_);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.m_7949_());
                blockpos$mutable.m_122173_(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double d3;
            if (this.f_19853_.m_6425_(blockpos).m_205070_(FluidTags.f_13132_) || !DismountHelper.m_38439_((double)(d3 = this.f_19853_.m_45573_(blockpos)))) continue;
            Vec3 vector3d1 = Vec3.m_82514_((Vec3i)blockpos, (double)d3);
            for (Pose pose : livingEntity.m_7431_()) {
                AABB axisalignedbb = livingEntity.m_21270_(pose);
                if (!DismountHelper.m_38439_((double)this.f_19853_.m_45573_(blockpos))) continue;
                livingEntity.m_20124_(pose);
                return vector3d1;
            }
        }
        return new Vec3(this.m_20185_(), this.m_142469_().f_82292_, this.m_20189_());
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + f1 - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    protected void m_20351_(Entity passenger) {
        if (passenger.m_6047_() && !passenger.f_19853_.f_46443_ && passenger instanceof ServerPlayer) {
            this.setSpeed(0.0f);
        }
        super.m_20351_(passenger);
    }

    public ItemStack getPickedResult(HitResult target) {
        ItemStack itemStack = new ItemStack((ItemLike)ItemsRegistry.ROVER_ITEM.get(), 1);
        itemStack.m_41784_().m_128405_("beyond_earth:fuel", ((Integer)this.f_19804_.m_135370_(FUEL)).intValue());
        return itemStack;
    }

    public void m_6074_() {
        this.spawnRoverItem();
        this.dropEquipment();
        if (!this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public AABB m_6921_() {
        return new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82377_(4.5, 4.5, 4.5);
    }

    public boolean m_6469_(DamageSource source, float p_21017_) {
        if (!source.m_19360_() && source.m_7639_() != null && source.m_7639_().m_6047_() && !this.m_20160_()) {
            this.spawnRoverItem();
            this.dropEquipment();
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    protected void spawnRoverItem() {
        ItemStack itemStack = new ItemStack((ItemLike)ItemsRegistry.ROVER_ITEM.get(), 1);
        itemStack.m_41784_().m_128405_("beyond_earth:fuel", ((Integer)this.m_20088_().m_135370_(FUEL)).intValue());
        ItemEntity entityToSpawn = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack);
        entityToSpawn.m_32010_(10);
        this.f_19853_.m_7967_((Entity)entityToSpawn);
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().get();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("fuel", ((Integer)this.m_20088_().m_135370_(FUEL)).intValue());
        compound.m_128379_("forward", ((Boolean)this.m_20088_().m_135370_(FORWARD)).booleanValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            this.inventory.deserializeNBT((CompoundTag)inventoryCustom);
        }
        this.f_19804_.m_135381_(FUEL, (Object)compound.m_128451_("fuel"));
        this.f_19804_.m_135381_(FORWARD, (Object)compound.m_128471_("forward"));
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        super.m_6096_(player, hand);
        InteractionResult result = InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        if (!this.f_19853_.f_46443_) {
            if (player.m_6047_()) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return RoverEntity.this.m_5446_();
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                        packetBuffer.m_130130_(RoverEntity.this.m_142049_());
                        return new RoverGui.GuiContainer(id, inventory, packetBuffer);
                    }
                }, buf -> buf.m_130130_(this.m_142049_()));
                return InteractionResult.CONSUME;
            }
            player.m_20329_((Entity)this);
            return InteractionResult.CONSUME;
        }
        return result;
    }

    public boolean getforward() {
        return (Boolean)this.f_19804_.m_135370_(FORWARD);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_183634_();
        if (Methods.tagCheck(FluidUtil2.findBucketFluid(this.inventory.getStackInSlot(0).m_41720_()), TagsRegistry.FLUID_VEHICLE_FUEL_TAG) && (Integer)this.f_19804_.m_135370_(FUEL) <= 2000) {
            this.m_20088_().m_135381_(FUEL, (Object)((Integer)this.m_20088_().m_135370_(FUEL) + 1000));
            this.inventory.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_));
        }
        if (this.m_20197_().isEmpty()) {
            return;
        }
        if (!(this.m_20197_().get(0) instanceof Player)) {
            return;
        }
        if (this.m_204029_(FluidTags.f_13131_)) {
            return;
        }
        this.FUEL_TIMER += 1.0f;
        Player passanger = (Player)this.m_20197_().get(0);
        passanger.m_183634_();
        if ((double)passanger.f_20902_ > 0.01 && (Integer)this.m_20088_().m_135370_(FUEL) != 0) {
            if (this.FUEL_TIMER > this.FUEL_USE_TICK) {
                this.f_19804_.m_135381_(FUEL, (Object)((Integer)this.m_20088_().m_135370_(FUEL) - 1));
                this.FUEL_TIMER = 0.0f;
            }
            this.f_19804_.m_135381_(FORWARD, (Object)true);
        } else if ((double)passanger.f_20902_ < -0.01 && (Integer)this.m_20088_().m_135370_(FUEL) != 0) {
            if (this.FUEL_TIMER > this.FUEL_USE_TICK) {
                this.f_19804_.m_135381_(FUEL, (Object)((Integer)this.m_20088_().m_135370_(FUEL) - 1));
                this.FUEL_TIMER = 0.0f;
            }
            this.f_19804_.m_135381_(FORWARD, (Object)false);
        }
    }

    @Override
    public float getFrictionInfluencedSpeed(float p_21331_) {
        return this.f_19861_ ? this.getSpeed() * (0.21600002f / (p_21331_ * p_21331_ * p_21331_)) : this.flyingSpeed;
    }

    @Override
    public void travel(Vec3 p_21280_) {
        this.calculateEntityAnimation(this, this instanceof FlyingAnimal);
        if (!this.m_20197_().isEmpty() && this.m_20197_().get(0) instanceof Player) {
            Player passanger = (Player)this.m_20197_().get(0);
            this.flyingSpeed = this.getSpeed() * 0.15f;
            this.f_19793_ = 1.0f;
            double pmovement = passanger.f_20902_;
            if (pmovement == 0.0 || (Integer)this.m_20088_().m_135370_(FUEL) == 0 || this.m_204029_(FluidTags.f_13131_)) {
                pmovement = 0.0;
                this.setSpeed(0.0f);
                if (this.speed != 0.0 && this.speed > 0.02) {
                    this.speed -= 0.02;
                }
            }
            if (((Boolean)this.f_19804_.m_135370_(FORWARD)).booleanValue() && (Integer)this.m_20088_().m_135370_(FUEL) != 0) {
                if ((double)this.getSpeed() >= 0.01 && this.speed <= 0.32) {
                    this.speed += 0.02;
                }
                if ((double)this.getSpeed() < 0.25) {
                    this.setSpeed(this.getSpeed() + 0.02f);
                }
            }
            if (!((Boolean)this.f_19804_.m_135370_(FORWARD)).booleanValue()) {
                if ((Integer)this.m_20088_().m_135370_(FUEL) != 0 && !this.m_204029_(FluidTags.f_13131_) && (double)this.getSpeed() <= 0.04) {
                    this.setSpeed(this.getSpeed() + 0.02f);
                }
                if ((double)this.getSpeed() >= 0.08) {
                    this.setSpeed(0.0f);
                }
            }
            if (((Boolean)this.f_19804_.m_135370_(FORWARD)).booleanValue()) {
                this.setWellRotationPlus(4.0f, 0.4f);
            } else {
                this.setWellRotationMinus(8.0f, 0.8f);
            }
            super.travel(new Vec3(0.0, 0.0, pmovement));
            return;
        }
        super.travel(new Vec3(0.0, 0.0, 0.0));
    }

    public void setWellRotationMinus(float rotation1, float rotation2) {
        double d0;
        this.animationSpeedOld = this.animationSpeed;
        double d1 = this.m_20185_() - this.f_19854_;
        float f1 = -Mth.m_14116_((float)((float)(d1 * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0))) * rotation1;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        this.animationSpeed += (f1 - this.animationSpeed) * rotation2;
        this.animationPosition += this.animationSpeed;
    }

    public void setWellRotationPlus(float rotation1, float rotation2) {
        double d0;
        this.animationSpeedOld = this.animationSpeed;
        double d1 = this.m_20185_() - this.f_19854_;
        float f1 = Mth.m_14116_((float)((float)(d1 * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0))) * rotation1;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        this.animationSpeed += (f1 - this.animationSpeed) * rotation2;
        this.animationPosition += this.animationSpeed;
    }

    public void calculateEntityAnimation(RoverEntity p_21044_, boolean p_21045_) {
        double d2;
        double d1;
        p_21044_.animationSpeedOld = p_21044_.animationSpeed;
        double d0 = p_21044_.m_20185_() - p_21044_.f_19854_;
        float f = (float)Math.sqrt(d0 * d0 + (d1 = p_21045_ ? p_21044_.m_20186_() - p_21044_.f_19855_ : 0.0) * d1 + (d2 = p_21044_.m_20189_() - p_21044_.f_19856_) * d2) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        p_21044_.animationSpeed += (f - p_21044_.animationSpeed) * 0.4f;
        p_21044_.animationPosition += p_21044_.animationSpeed;
    }
}

