/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.events;

import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.events.forge.EntityGravityEvent;

public class EntityGravity {
    public static final float MOON_GRAVITY = 0.03f;
    public static final float MARS_GRAVITY = 0.04f;
    public static final float MERCURY_GRAVITY = 0.03f;
    public static final float GLACIO_GRAVITY = 0.04f;
    public static final float ORBIT_GRAVITY = 0.02f;

    public static void gravity(LivingEntity entity, Level level) {
        if (Methods.isWorld(level, Methods.moon)) {
            EntityGravity.gravitySystem(entity, 0.03f);
        } else if (Methods.isWorld(level, Methods.mars)) {
            EntityGravity.gravitySystem(entity, 0.04f);
        } else if (Methods.isWorld(level, Methods.mercury)) {
            EntityGravity.gravitySystem(entity, 0.03f);
        } else if (Methods.isWorld(level, Methods.glacio)) {
            EntityGravity.gravitySystem(entity, 0.04f);
        } else if (Methods.isOrbitWorld(level)) {
            EntityGravity.gravitySystem(entity, 0.02f);
        }
    }

    public static void gravitySystem(LivingEntity entity, float gravity) {
        if (!EntityGravity.getCondition(entity)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityGravityEvent((Entity)entity, gravity))) {
            return;
        }
        entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_ / 0.98 + 0.08 - (double)gravity, entity.m_20184_().f_82481_);
    }

    private static boolean getCondition(LivingEntity entity) {
        if (entity instanceof Player) {
            return EntityGravity.getPlayerEntityCondition((Player)entity);
        }
        return EntityGravity.getLivingEntityCondition(entity);
    }

    private static boolean getPlayerEntityCondition(Player player) {
        return EntityGravity.getLivingEntityCondition((LivingEntity)player) && !player.m_150110_().f_35935_;
    }

    private static boolean getLivingEntityCondition(LivingEntity entity) {
        return EntityGravity.getEntityCondition((Entity)entity) && !entity.m_21255_() && !entity.m_21023_(MobEffects.f_19591_) && !entity.m_21023_(MobEffects.f_19620_);
    }

    private static boolean getEntityCondition(Entity entity) {
        return !entity.m_20069_() && !entity.m_20077_() && !entity.m_20068_() && !Methods.isVehicle(entity);
    }
}

