/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.fluids;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.mrscauthd.beyond_earth.registries.BlocksRegistry;
import net.mrscauthd.beyond_earth.registries.FluidsRegistry;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;

public class FuelFluid
extends FlowingFluid {
    public Fluid m_5615_() {
        return (Fluid)FluidsRegistry.FLOWING_FUEL.get();
    }

    public Fluid m_5613_() {
        return (Fluid)FluidsRegistry.FUEL_STILL.get();
    }

    public Item m_6859_() {
        return (Item)ItemsRegistry.FUEL_BUCKET.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7450_(Level worldIn, BlockPos pos, FluidState state, Random random) {
        if (!state.m_76170_() && !((Boolean)state.m_61143_((Property)f_75947_)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12540_, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123768_, (double)pos.m_123341_() + random.nextDouble(), (double)pos.m_123342_() + random.nextDouble(), (double)pos.m_123343_() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    protected ParticleOptions m_7792_() {
        return ParticleTypes.f_123803_;
    }

    protected boolean m_6760_() {
        return false;
    }

    protected void m_7456_(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        BlockEntity tileentity = state.m_155947_() ? worldIn.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)tileentity);
    }

    protected int m_6719_(LevelReader p_76074_) {
        return 4;
    }

    protected BlockState m_5804_(FluidState p_76136_) {
        return (BlockState)((LiquidBlock)BlocksRegistry.FUEL_BLOCK.get()).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(FuelFluid.m_76092_((FluidState)p_76136_)));
    }

    public boolean m_7444_(FluidState state) {
        return false;
    }

    public int m_7430_(FluidState p_164509_) {
        return 4;
    }

    public boolean m_6212_(Fluid fluidIn) {
        return fluidIn == FluidsRegistry.FUEL_STILL.get() || fluidIn == FluidsRegistry.FLOWING_FUEL.get();
    }

    protected int m_6713_(LevelReader p_76087_) {
        return 1;
    }

    public int m_6718_(LevelReader p_76120_) {
        return 8;
    }

    protected boolean m_5486_(FluidState p_76127_, BlockGetter p_76128_, BlockPos p_76129_, Fluid p_76130_, Direction p_76131_) {
        return p_76131_ == Direction.DOWN && !p_76130_.m_205067_(FluidTags.f_13131_);
    }

    protected float m_6752_() {
        return 100.0f;
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)new ResourceLocation("beyond_earth", "blocks/fluid_fuel_still"), (ResourceLocation)new ResourceLocation("beyond_earth", "blocks/fluid_fuel_flow")).overlay(new ResourceLocation("beyond_earth", "blocks/fuel_overlay")).translationKey("block.beyond_earth.fuel").sound(SoundEvents.f_11781_, SoundEvents.f_11778_).build((Fluid)this);
    }

    public static class Source
    extends FuelFluid {
        @Override
        public int m_7430_(FluidState p_164509_) {
            return 8;
        }

        @Override
        public boolean m_7444_(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FuelFluid {
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> p_76046_) {
            super.m_7180_(p_76046_);
            p_76046_.m_61104_(new Property[]{f_75948_});
        }

        @Override
        public int m_7430_(FluidState p_164509_) {
            return (Integer)p_164509_.m_61143_((Property)f_75948_);
        }

        @Override
        public boolean m_7444_(FluidState state) {
            return false;
        }
    }
}

