/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.gauge;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;

public class GaugeValueFluidStack
implements IGaugeValue {
    private FluidStack stack;
    private int capacity;

    public GaugeValueFluidStack() {
    }

    public GaugeValueFluidStack(FluidStack stack, int capacity) {
        this.setStack(stack);
        this.setCapacity(capacity);
    }

    public void deserializeNBT(CompoundTag compound) {
        this.setStack(FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("stack")));
        this.setCapacity(compound.m_128451_("capacity"));
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        CompoundTag stackCompound = new CompoundTag();
        this.getStack().writeToNBT(stackCompound);
        compound.m_128365_("stack", (Tag)stackCompound);
        compound.m_128405_("capacity", this.getCapacity());
        return compound;
    }

    @Override
    public int getColor() {
        FluidStack fluidStack = this.getStack();
        FluidAttributes attributes = fluidStack.getFluid().getAttributes();
        return attributes.getColor(fluidStack);
    }

    public FluidStack getStack() {
        return this.stack;
    }

    public void setStack(FluidStack stack) {
        this.stack = stack;
    }

    @Override
    public Component getDisplayName() {
        return this.getStack().getDisplayName();
    }

    @Override
    public String getUnit() {
        return "mB";
    }

    @Override
    public int getAmount() {
        return this.getStack().getAmount();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public boolean isReverse() {
        return false;
    }
}

