/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.guis.screens.planetselection.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.simple.SimpleChannel;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;
import net.mrscauthd.beyond_earth.guis.helper.ImageButtonPlacer;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.PlanetSelectionGuiNetworkHandler;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.PlanetSelectionGuiWindow;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.helper.CategoryHelper;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.helper.PlanetSelectionGuiNetworkHandlerHelper;

@OnlyIn(value=Dist.CLIENT)
public class PlanetSelectionGuiHelper {
    public static ImageButtonPlacer addCategoryButton(PlanetSelectionGuiWindow screen, CategoryHelper categoryHelper, int x, int row, int width, int height, int newCategory, boolean condition, ImageButtonPlacer.Types type, List<String> list, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture, Component title) {
        ImageButtonPlacer button = screen.addButton(x, 0, row, width, height, condition, type, list, buttonTexture, hoverButtonTexture, title, onPress -> {
            if (condition) {
                categoryHelper.set(newCategory);
                screen.scrollIndex = 0;
                screen.updateButtonVisibility();
            }
        });
        return button;
    }

    public static ImageButtonPlacer addHandlerButton(PlanetSelectionGuiWindow screen, int x, int row, int width, int height, boolean condition, SimpleChannel simpleChannel, PlanetSelectionGuiNetworkHandlerHelper handler, ImageButtonPlacer.Types type, List<String> list, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture, Component title) {
        ImageButtonPlacer button = screen.addButton(x, 0, row, width, height, condition, type, list, buttonTexture, hoverButtonTexture, title, onPress -> {
            if (condition) {
                PlanetSelectionGuiHelper.callPacketHandler(simpleChannel, handler);
                screen.scrollIndex = 0;
                screen.updateButtonVisibility();
            }
        });
        return button;
    }

    public static ImageButtonPlacer addBackButton(PlanetSelectionGuiWindow screen, int x, int row, int width, int height, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture, Component title, Button.OnPress onPress) {
        ImageButtonPlacer button = screen.addButton(x, 0, row, width, height, false, null, null, buttonTexture, hoverButtonTexture, title, onPress);
        return button;
    }

    public static void addCircle(double x, double y, double radius, int sides) {
        double width;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157429_((float)0.14117648f, (float)0.19607843f, (float)0.48235294f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85814_);
        for (double f1 = width = radius - 0.5; f1 < width + 1.0; f1 += 0.1) {
            for (int f2 = 0; f2 <= sides; ++f2) {
                double angle = Math.PI * 2 * (double)f2 / (double)sides + Math.toRadians(180.0);
                bufferBuilder.m_5483_(x + Math.sin(angle) * f1, y + Math.cos(angle) * f1, 0.0).m_5752_();
            }
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void addRotatedObject(PlanetSelectionGuiWindow screen, PoseStack ms, ResourceLocation texture, float x, float y, int width, int height, float rotation) {
        ms.m_85836_();
        ms.m_85837_((double)(screen.f_96543_ / 2), (double)(screen.f_96544_ / 2), 0.0);
        ms.m_85845_(new Quaternion(Vector3f.f_122227_, rotation, true));
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiHelper.blit(ms, x, y, 0.0f, 0.0f, width, height, width, height);
        ms.m_85837_((double)(-screen.f_96543_ / 2), (double)(-screen.f_96544_ / 2), 0.0);
        ms.m_85849_();
    }

    public static void addTexture(PoseStack poseStack, int x, int y, int width, int height, ResourceLocation texture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
    }

    public static void enableRenderSystem() {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
    }

    public static void disableRenderSystem() {
        RenderSystem.m_69461_();
    }

    public static boolean categoryRange(int category, int start, int end) {
        return category >= start && category <= end;
    }

    public static boolean checkTier(String rocketType, int stage) {
        int tier = 0;
        if (rocketType.equals("entity.beyond_earth.rocket_t1")) {
            tier = 1;
        } else if (rocketType.equals("entity.beyond_earth.rocket_t2")) {
            tier = 2;
        } else if (rocketType.equals("entity.beyond_earth.rocket_t3")) {
            tier = 3;
        } else if (rocketType.equals("entity.beyond_earth.rocket_t4")) {
            tier = 4;
        }
        return tier >= stage;
    }

    public static Component tl(String text) {
        return new TranslatableComponent("gui.beyond_earth.planet_selection." + text);
    }

    public static void callPacketHandler(SimpleChannel simpleChannel, PlanetSelectionGuiNetworkHandlerHelper handler) {
        simpleChannel.sendToServer((Object)handler);
    }

    public static PlanetSelectionGuiNetworkHandler getNetworkHandler(int handler) {
        return new PlanetSelectionGuiNetworkHandler(handler);
    }
}

