/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.capabilities.oxygen.OxygenUtil;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeTypes;
import net.mrscauthd.beyond_earth.crafting.CompressingRecipe;
import net.mrscauthd.beyond_earth.crafting.FuelRefiningRecipe;
import net.mrscauthd.beyond_earth.crafting.GeneratingRecipe;
import net.mrscauthd.beyond_earth.crafting.IngredientStack;
import net.mrscauthd.beyond_earth.crafting.OxygenBubbleDistributorRecipe;
import net.mrscauthd.beyond_earth.crafting.OxygenLoaderRecipe;
import net.mrscauthd.beyond_earth.crafting.RocketPart;
import net.mrscauthd.beyond_earth.crafting.SpaceStationRecipe;
import net.mrscauthd.beyond_earth.crafting.WorkbenchingRecipe;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.fluids.FluidUtil2;
import net.mrscauthd.beyond_earth.gauge.GaugeTextHelper;
import net.mrscauthd.beyond_earth.gauge.GaugeValueHelper;
import net.mrscauthd.beyond_earth.guis.helper.GridPlacer;
import net.mrscauthd.beyond_earth.guis.helper.GuiHelper;
import net.mrscauthd.beyond_earth.guis.helper.IPlacer;
import net.mrscauthd.beyond_earth.guis.helper.RocketPartGridPlacer;
import net.mrscauthd.beyond_earth.guis.screens.coalgenerator.CoalGeneratorGui;
import net.mrscauthd.beyond_earth.guis.screens.coalgenerator.CoalGeneratorGuiWindow;
import net.mrscauthd.beyond_earth.guis.screens.compressor.CompressorGui;
import net.mrscauthd.beyond_earth.guis.screens.compressor.CompressorGuiWindow;
import net.mrscauthd.beyond_earth.guis.screens.fuelrefinery.FuelRefineryGui;
import net.mrscauthd.beyond_earth.guis.screens.fuelrefinery.FuelRefineryGuiWindow;
import net.mrscauthd.beyond_earth.guis.screens.nasaworkbench.NasaWorkbenchGui;
import net.mrscauthd.beyond_earth.guis.screens.nasaworkbench.NasaWorkbenchGuiWindow;
import net.mrscauthd.beyond_earth.guis.screens.oxygenbubbledistributor.OxygenBubbleDistributorGui;
import net.mrscauthd.beyond_earth.guis.screens.oxygenbubbledistributor.OxygenBubbleDistributorGuiWindow;
import net.mrscauthd.beyond_earth.guis.screens.oxygenloader.OxygenLoaderGui;
import net.mrscauthd.beyond_earth.guis.screens.oxygenloader.OxygenLoaderGuiWindow;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.PlanetSelectionGuiWindow;
import net.mrscauthd.beyond_earth.guis.screens.rocket.RocketGui;
import net.mrscauthd.beyond_earth.guis.screens.rocket.RocketGuiWindow;
import net.mrscauthd.beyond_earth.guis.screens.rover.RoverGuiWindow;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.CoalGeneratorGuiContainerHandler;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.CompressorGuiContainerHandler;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.PlanetSelectionGuiJeiHandler;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.RocketGuiContainerHandler;
import net.mrscauthd.beyond_earth.jei.jeiguihandlers.RoverGuiContainerHandler;
import net.mrscauthd.beyond_earth.machines.tile.NASAWorkbenchBlockEntity;
import net.mrscauthd.beyond_earth.registries.BlocksRegistry;
import net.mrscauthd.beyond_earth.registries.EntitiesRegistry;
import net.mrscauthd.beyond_earth.registries.FluidsRegistry;
import net.mrscauthd.beyond_earth.registries.ItemsRegistry;
import net.mrscauthd.beyond_earth.registries.RocketPartsRegistry;
import net.mrscauthd.beyond_earth.registries.TagsRegistry;
import net.mrscauthd.beyond_earth.utils.Rectangle2d;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelper;
    private Map<Fluid, List<ItemStack>> fluidFullItemStacks;
    private List<ItemStack> oxygenFullItemStacks;
    private List<Fluid> fuelTagFluids;

    private ClientLevel getLevel() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91073_;
    }

    public List<ItemStack> getFluidFullItemStacks(Fluid fluid) {
        return this.fluidFullItemStacks.computeIfAbsent(fluid, this::generateFluidFullIngredients);
    }

    public List<ItemStack> getFluidFullItemStacks(Collection<Fluid> fluids) {
        return fluids.stream().flatMap(f -> this.getFluidFullItemStacks((Fluid)f).stream()).collect(Collectors.toList());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("beyond_earth", "default");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        int inventorySlotCount = 36;
        registration.addRecipeTransferHandler(OxygenLoaderGui.GuiContainer.class, OxygenLoaderJeiCategory.recipeType, 0, 1, 4, inventorySlotCount);
        registration.addRecipeTransferHandler(OxygenBubbleDistributorGui.GuiContainer.class, OxygenBubbleDistributorJeiCategory.recipeType, 0, 1, 2, inventorySlotCount);
        registration.addRecipeTransferHandler(CoalGeneratorGui.GuiContainer.class, CoalGeneratorJeiCategory.recipeType, 0, 1, 1, inventorySlotCount);
        registration.addRecipeTransferHandler(CompressorGui.GuiContainer.class, CompressorJeiCategory.recipeType, 0, 1, 2, inventorySlotCount);
        int workbenchPartSlotStart = 1;
        int workbenchPartSlotCount = NASAWorkbenchBlockEntity.getBasicPartSlots();
        registration.addRecipeTransferHandler(NasaWorkbenchGui.GuiContainer.class, NasaWorkbenchJeiCategory.recipeType, workbenchPartSlotStart, workbenchPartSlotCount, workbenchPartSlotStart + workbenchPartSlotCount, inventorySlotCount);
        registration.addRecipeTransferHandler(FuelRefineryGui.GuiContainer.class, FuelRefineryJeiCategory.recipeType, 0, 1, 4, inventorySlotCount);
        registration.addRecipeTransferHandler(RocketGui.GuiContainer.class, RocketTier1JeiCategory.recipeType, 0, 1, 1, inventorySlotCount);
        registration.addRecipeTransferHandler(RocketGui.GuiContainer.class, RocketTier2JeiCategory.recipeType, 0, 1, 1, inventorySlotCount);
        registration.addRecipeTransferHandler(RocketGui.GuiContainer.class, RocketTier3JeiCategory.recipeType, 0, 1, 1, inventorySlotCount);
        registration.addRecipeTransferHandler(RocketGui.GuiContainer.class, RocketTier4JeiCategory.recipeType, 0, 1, 1, inventorySlotCount);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(NasaWorkbenchGuiWindow.class, 108, 49, 14, 14, new RecipeType[]{NasaWorkbenchJeiCategory.recipeType});
        registration.addRecipeClickArea(OxygenLoaderGuiWindow.class, 48, 36, 24, 17, new RecipeType[]{OxygenLoaderJeiCategory.recipeType});
        registration.addRecipeClickArea(OxygenBubbleDistributorGuiWindow.class, 48, 36, 24, 17, new RecipeType[]{OxygenBubbleDistributorJeiCategory.recipeType});
        registration.addRecipeClickArea(FuelRefineryGuiWindow.class, 48, 36, 24, 17, new RecipeType[]{FuelRefineryJeiCategory.recipeType});
        registration.addGuiContainerHandler(CoalGeneratorGuiWindow.class, (IGuiContainerHandler)new CoalGeneratorGuiContainerHandler());
        registration.addGuiContainerHandler(CompressorGuiWindow.class, (IGuiContainerHandler)new CompressorGuiContainerHandler());
        registration.addGuiContainerHandler(RocketGuiWindow.class, (IGuiContainerHandler)new RocketGuiContainerHandler());
        registration.addGuiContainerHandler(RoverGuiWindow.class, (IGuiContainerHandler)new RoverGuiContainerHandler());
        registration.addGuiScreenHandler(PlanetSelectionGuiWindow.class, (IScreenHandler)new PlanetSelectionGuiJeiHandler());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelper = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new OxygenLoaderJeiCategory(this, jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new OxygenBubbleDistributorJeiCategory(this, jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CoalGeneratorJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new NasaWorkbenchJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RocketTier1JeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RocketTier2JeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RocketTier3JeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RocketTier4JeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressorJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelRefineryJeiCategory(this, jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RoverJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SpaceStationJeiCategory(jeiHelper.getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.fluidFullItemStacks = new HashMap<Fluid, List<ItemStack>>();
        this.oxygenFullItemStacks = this.generateOxygenLoadingItems();
        this.fuelTagFluids = this.generateFuelTagFluids();
        registration.addRecipes(OxygenLoaderJeiCategory.recipeType, this.generateOxygenLoaderRecipes());
        registration.addRecipes(OxygenBubbleDistributorJeiCategory.recipeType, this.generateOxygenBubbleDistributorRecipes());
        registration.addRecipes(CoalGeneratorJeiCategory.recipeType, this.generateGeneratorRecipes());
        registration.addRecipes(NasaWorkbenchJeiCategory.recipeType, this.generateWorkbenchRecipes());
        registration.addRecipes(RocketTier1JeiCategory.recipeType, this.generateFuelLoadingRecipes());
        registration.addRecipes(RocketTier2JeiCategory.recipeType, this.generateFuelLoadingRecipes());
        registration.addRecipes(RocketTier3JeiCategory.recipeType, this.generateFuelLoadingRecipes());
        registration.addRecipes(RocketTier4JeiCategory.recipeType, this.generateFuelLoadingRecipes());
        registration.addRecipes(RoverJeiCategory.recipeType, this.generateFuelLoadingRecipes());
        registration.addRecipes(CompressorJeiCategory.recipeType, this.generateCompressingRecipes());
        registration.addRecipes(FuelRefineryJeiCategory.recipeType, this.generateFuelMakerRecipes());
        registration.addRecipes(SpaceStationJeiCategory.recipeType, this.generateSpaceStationRecipes());
        TranslatableComponent oilDescriptionKey = new TranslatableComponent("jei.tooltip.beyond_earth.oil");
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ItemsRegistry.OIL_BUCKET.get(), 1), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{oilDescriptionKey});
        registration.addIngredientInfo((Object)new FluidStack((Fluid)FluidsRegistry.OIL_STILL.get(), 1000), (IIngredientType)ForgeTypes.FLUID_STACK, new Component[]{oilDescriptionKey});
    }

    private List<ItemStack> generateOxygenLoadingItems() {
        return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(OxygenUtil::canReceive).map(OxygenUtil::makeFull).collect(Collectors.toList());
    }

    private List<OxygenLoaderRecipe> generateOxygenLoaderRecipes() {
        return BeyondEarthRecipeTypes.OXYGEN_LOADING.getRecipes((Level)this.getLevel());
    }

    private List<OxygenBubbleDistributorRecipe> generateOxygenBubbleDistributorRecipes() {
        return BeyondEarthRecipeTypes.OXYGEN_BUBBLE_DISTRIBUTING.getRecipes((Level)this.getLevel());
    }

    private List<GeneratingRecipe> generateGeneratorRecipes() {
        return BeyondEarthRecipeTypes.COAL_GENERATING.getRecipes((Level)this.getLevel());
    }

    private List<WorkbenchingRecipe> generateWorkbenchRecipes() {
        return BeyondEarthRecipeTypes.NASA_WORKBENCHING.getRecipes((Level)this.getLevel());
    }

    private List<CompressingRecipe> generateCompressingRecipes() {
        return BeyondEarthRecipeTypes.COMPRESSING.getRecipes((Level)this.getLevel());
    }

    private List<ItemStack> generateFluidFullIngredients(Fluid fluid) {
        return ForgeRegistries.ITEMS.getValues().stream().map(i -> new ItemStack((ItemLike)i)).filter(is -> FluidUtil2.canFill(is, fluid)).map(is -> FluidUtil2.makeFull(is, fluid)).collect(Collectors.toList());
    }

    private List<FuelRefiningRecipe> generateFuelMakerRecipes() {
        return BeyondEarthRecipeTypes.FUEL_REFINING.getRecipes((Level)this.getLevel());
    }

    private List<Fluid> generateFuelTagFluids() {
        return ForgeRegistries.FLUIDS.getValues().stream().filter(f -> f.m_7444_(f.m_76145_()) && Methods.tagCheck(f, TagsRegistry.FLUID_VEHICLE_FUEL_TAG)).collect(Collectors.toList());
    }

    private List<FuelLoadingRecipe> generateFuelLoadingRecipes() {
        ArrayList<ItemStack> fuelTagBuckets = new ArrayList<ItemStack>();
        for (Fluid fluid : this.fuelTagFluids) {
            fuelTagBuckets.add(new ItemStack((ItemLike)fluid.m_6859_()));
        }
        FuelLoadingRecipe recipe = new FuelLoadingRecipe(fuelTagBuckets, this.fuelTagFluids);
        ArrayList<FuelLoadingRecipe> recipes = new ArrayList<FuelLoadingRecipe>();
        recipes.add(recipe);
        return recipes;
    }

    private List<SpaceStationRecipe> generateSpaceStationRecipes() {
        ArrayList<SpaceStationRecipe> recipes = new ArrayList<SpaceStationRecipe>();
        this.getLevel().m_7465_().m_44043_(SpaceStationRecipe.KEY).ifPresent(r -> recipes.add((SpaceStationRecipe)r));
        return recipes;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksRegistry.OXYGEN_LOADER_BLOCK.get()), new RecipeType[]{OxygenLoaderJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksRegistry.OXYGEN_BUBBLE_DISTRIBUTOR_BLOCK.get()), new RecipeType[]{OxygenBubbleDistributorJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksRegistry.COAL_GENERATOR_BLOCK.get()), new RecipeType[]{CoalGeneratorJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemsRegistry.NASA_WORKBENCH_ITEM.get()), new RecipeType[]{NasaWorkbenchJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksRegistry.COMPRESSOR_BLOCK.get()), new RecipeType[]{CompressorJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlocksRegistry.FUEL_REFINERY_BLOCK.get()), new RecipeType[]{FuelRefineryJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemsRegistry.TIER_1_ROCKET_ITEM.get()), new RecipeType[]{RocketTier1JeiCategory.recipeType, SpaceStationJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemsRegistry.TIER_2_ROCKET_ITEM.get()), new RecipeType[]{RocketTier2JeiCategory.recipeType, SpaceStationJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemsRegistry.TIER_3_ROCKET_ITEM.get()), new RecipeType[]{RocketTier3JeiCategory.recipeType, SpaceStationJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemsRegistry.TIER_4_ROCKET_ITEM.get()), new RecipeType[]{RocketTier4JeiCategory.recipeType, SpaceStationJeiCategory.recipeType});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ItemsRegistry.ROVER_ITEM.get()), new RecipeType[]{RoverJeiCategory.recipeType});
    }

    public static void placeRocketParts(int left, int top, int mod, IPlacer placer, RocketPart part, IRecipeLayoutBuilder builder, WorkbenchingRecipe recipe) {
        List<Ingredient> ingredients = recipe.getParts().get((Object)part);
        RocketPartGridPlacer.place(left, top, mod, placer, part, (i, bounds) -> {
            Ingredient ingredient = ingredients != null && i < ingredients.size() ? (Ingredient)ingredients.get((int)i) : Ingredient.f_43901_;
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, bounds.getX(), bounds.getY());
            slot.addIngredients(ingredient);
        });
    }

    public static IDrawableStatic createFireStatic(IGuiHelper guiHelper) {
        return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.FIRE_PATH, 14, 14).build();
    }

    public static IDrawableAnimated createFireAnimated(IGuiHelper guiHelper) {
        return JeiPlugin.createFireAnimated(guiHelper, 200);
    }

    public static IDrawableAnimated createFireAnimated(IGuiHelper guiHelper, int ticks) {
        return JeiPlugin.createFireAnimated(guiHelper, JeiPlugin.createFireStatic(guiHelper), ticks);
    }

    public static IDrawableAnimated createFireAnimated(IGuiHelper guiHelper, IDrawableStatic fireStatic, int ticks) {
        return guiHelper.createAnimatedDrawable(fireStatic, ticks, IDrawableAnimated.StartDirection.TOP, true);
    }

    public static IDrawableBuilder drawableBuilder(IGuiHelper guiHelper, ResourceLocation path, int width, int height) {
        return guiHelper.drawableBuilder(path, 0, 0, width, height).setTextureSize(width, height);
    }

    public static LoadingCache<Integer, IDrawableAnimated> createFires(final IGuiHelper guiHelper) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer time) {
                return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.FIRE_PATH, 14, 14).buildAnimated(time.intValue(), IDrawableAnimated.StartDirection.TOP, true);
            }
        });
    }

    public static LoadingCache<Integer, IDrawableAnimated> createArrows(final IGuiHelper guiHelper) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer time) {
                return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.ARROW_PATH, 24, 17).buildAnimated(time.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public static LoadingCache<Integer, IDrawableAnimated> createEnergies(final IGuiHelper guiHelper, final boolean inverted) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer time) {
                return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.ENERGY_PATH, 24, 48).buildAnimated(time.intValue(), inverted ? IDrawableAnimated.StartDirection.TOP : IDrawableAnimated.StartDirection.BOTTOM, inverted);
            }
        });
    }

    public static LoadingCache<Integer, IDrawableAnimated> createUsingEnergies(IGuiHelper guiHelper) {
        return JeiPlugin.createEnergies(guiHelper, true);
    }

    public static LoadingCache<Integer, IDrawableAnimated> createGeneratingEnergies(IGuiHelper guiHelper) {
        return JeiPlugin.createEnergies(guiHelper, false);
    }

    public static void drawText(PoseStack stack, IDrawable background, String text) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int stringWidth = font.m_92895_(text);
        float f = background.getWidth() - 5 - stringWidth;
        int n = background.getHeight();
        Objects.requireNonNull(font);
        font.m_92883_(stack, text, f, (float)(n - 9 - 5), 0x808080);
    }

    public static void drawTextTime(PoseStack stack, IDrawable background, int ticks) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String text = numberInstance.format((float)ticks / 20.0f) + "s";
        JeiPlugin.drawText(stack, background, text);
    }

    public static class OxygenLoaderJeiCategory
    implements IRecipeCategory<OxygenLoaderRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "oxygen_loader");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "oxygen_loader"), OxygenLoaderRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/oxygen_loader.png");
        private static final Component title = new TranslatableComponent("container.beyond_earth.oxygen_loader");
        public static final int INPUT_TANK_LEFT = 8;
        public static final int INPUT_TANK_TOP = 8;
        public static final int OUTPUT_TANK_LEFT = 74;
        public static final int OUTPUT_TANK_TOP = 8;
        public static final int ENERGY_LEFT = 114;
        public static final int ENERGY_TOP = 8;
        private final JeiPlugin plugin;
        private final IDrawableStatic background;
        private final IDrawable fluidOverlay;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public OxygenLoaderJeiCategory(JeiPlugin plugin, IGuiHelper guiHelper) {
            this.plugin = plugin;
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 147, 64).setTextureSize(147, 64).build();
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public void setRecipe(IRecipeLayoutBuilder builder, OxygenLoaderRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 25, 9);
            input.addItemStacks(this.plugin.getFluidFullItemStacks(recipe.getInput().getFluids()));
            IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 39);
            output.addItemStacks(this.plugin.oxygenFullItemStacks);
            IRecipeSlotBuilder tank = builder.addSlot(RecipeIngredientRole.CATALYST, 8, 8);
            tank.setFluidRenderer(1, false, 14, 48).setOverlay(this.fluidOverlay, 0, 0);
            tank.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getInput().toStacks());
        }

        public void draw(OxygenLoaderRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)200)).draw(stack, 114, 8);
            GuiHelper.drawOxygenTank(stack, 74, 8, 1.0);
        }

        public List<Component> getTooltipStrings(OxygenLoaderRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getValueText(GaugeValueHelper.getOxygen(recipe.getOxygen())).build());
            }
            return Collections.emptyList();
        }

        public RecipeType<OxygenLoaderRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends OxygenLoaderRecipe> getRecipeClass() {
            return OxygenLoaderRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public Rectangle2d getInputTankBounds() {
            return GuiHelper.getFluidTankBounds(8, 8);
        }

        public Rectangle2d getOutputTankBounds() {
            return GuiHelper.getFluidTankBounds(74, 8);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(114, 8);
        }
    }

    public static class OxygenBubbleDistributorJeiCategory
    implements IRecipeCategory<OxygenBubbleDistributorRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "oxygen_bubble_distributor");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "oxygen_bubble_distributor"), OxygenBubbleDistributorRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/oxygen_bubble_distributor.png");
        private static final Component title = new TranslatableComponent("container.beyond_earth.oxygen_bubble_distributor");
        public static final int INPUT_TANK_LEFT = 8;
        public static final int INPUT_TANK_TOP = 8;
        public static final int OUTPUT_TANK_LEFT = 74;
        public static final int OUTPUT_TANK_TOP = 8;
        public static final int ENERGY_LEFT = 114;
        public static final int ENERGY_TOP = 8;
        private final JeiPlugin plugin;
        private final IDrawableStatic background;
        private final IDrawable fluidOverlay;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public OxygenBubbleDistributorJeiCategory(JeiPlugin plugin, IGuiHelper guiHelper) {
            this.plugin = plugin;
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 147, 64).setTextureSize(147, 64).build();
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public void setRecipe(IRecipeLayoutBuilder builder, OxygenBubbleDistributorRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 25, 9);
            input.addItemStacks(this.plugin.getFluidFullItemStacks(recipe.getInput().getFluids()));
            IRecipeSlotBuilder tank = builder.addSlot(RecipeIngredientRole.CATALYST, 8, 8);
            tank.setFluidRenderer(1, false, 14, 48).setOverlay(this.fluidOverlay, 0, 0);
            tank.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getInput().toStacks());
        }

        public void draw(OxygenBubbleDistributorRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)200)).draw(stack, 114, 8);
            GuiHelper.drawOxygenTank(stack, 74, 8, 1.0);
        }

        public List<Component> getTooltipStrings(OxygenBubbleDistributorRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getValueText(GaugeValueHelper.getOxygen(recipe.getOxygen())).build());
            }
            return Collections.emptyList();
        }

        public RecipeType<OxygenBubbleDistributorRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends OxygenBubbleDistributorRecipe> getRecipeClass() {
            return OxygenBubbleDistributorRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public Rectangle2d getInputTankBounds() {
            return GuiHelper.getFluidTankBounds(8, 8);
        }

        public Rectangle2d getOutputTankBounds() {
            return GuiHelper.getFluidTankBounds(74, 8);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(114, 8);
        }
    }

    public static class CoalGeneratorJeiCategory
    implements IRecipeCategory<GeneratingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "coal_generator");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "coal_generator"), GeneratingRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/coal_generator.png");
        private static final Component title = new TranslatableComponent("container.beyond_earth.coal_generator");
        public static final int FIRE_LEFT = 45;
        public static final int FIRE_TOP = 45;
        public static final int ENERGY_LEFT = 103;
        public static final int ENERGY_TOP = 15;
        private final IDrawableStatic background;
        private final LoadingCache<Integer, IDrawableAnimated> fires;
        private final LoadingCache<Integer, IDrawableAnimated> energies;

        public CoalGeneratorJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 144, 84).setTextureSize(144, 84).build();
            this.fires = JeiPlugin.createFires(guiHelper);
            this.energies = JeiPlugin.createGeneratingEnergies(guiHelper);
        }

        public void setRecipe(IRecipeLayoutBuilder builder, GeneratingRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 45, 26);
            input.addIngredients(recipe.getInput());
        }

        public void draw(GeneratingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
            int burnTime = recipe.getBurnTime();
            ((IDrawableAnimated)this.fires.getUnchecked((Object)burnTime)).draw(stack, 45, 45);
            ((IDrawableAnimated)this.energies.getUnchecked((Object)200)).draw(stack, 103, 15);
            JeiPlugin.drawTextTime(stack, this.getBackground(), burnTime);
        }

        public List<Component> getTooltipStrings(GeneratingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getFireBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getValueText(GaugeValueHelper.getBurnTime(recipe.getBurnTime())).build());
            }
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getGeneratingPerTickText(GaugeValueHelper.getEnergy(2)).build());
            }
            return Collections.emptyList();
        }

        public RecipeType<GeneratingRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends GeneratingRecipe> getRecipeClass() {
            return GeneratingRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public Rectangle2d getFireBounds() {
            return GuiHelper.getFireBounds(45, 45);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(103, 15);
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }
    }

    public static class CompressorJeiCategory
    implements IRecipeCategory<CompressingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "compressor");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "compressor"), CompressingRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/compressor.png");
        private static final Component title = new TranslatableComponent("container.beyond_earth.compressor");
        public static final int ARROW_LEFT = 36;
        public static final int ARROW_TOP = 29;
        public static final int ENERGY_LEFT = 103;
        public static final int ENERGY_TOP = 15;
        private final IDrawableStatic background;
        private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public CompressorJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 144, 84).setTextureSize(144, 84).build();
            this.cachedArrows = JeiPlugin.createArrows(guiHelper);
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public void setRecipe(IRecipeLayoutBuilder builder, CompressingRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 15, 30);
            input.addIngredients(recipe.getInput());
            IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 29);
            output.addItemStack(recipe.getOutput());
        }

        public void draw(CompressingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
            int cookTime = recipe.getCookTime();
            ((IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime)).draw(stack, 36, 29);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)cookTime)).draw(stack, 103, 15);
            JeiPlugin.drawTextTime(stack, this.getBackground(), cookTime);
        }

        public List<Component> getTooltipStrings(CompressingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            return Collections.emptyList();
        }

        private Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(103, 15);
        }

        public RecipeType<CompressingRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends CompressingRecipe> getRecipeClass() {
            return CompressingRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }
    }

    public static class NasaWorkbenchJeiCategory
    implements IRecipeCategory<WorkbenchingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "nasa_workbench");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "nasa_workbench"), WorkbenchingRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/nasa_workbench.png");
        private static final Component title = new TranslatableComponent("container.beyond_earth.nasa_workbench");
        private final IDrawableStatic background;

        public NasaWorkbenchJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 176, 122).setTextureSize(176, 122).build();
        }

        public void setRecipe(IRecipeLayoutBuilder builder, WorkbenchingRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            builder.moveRecipeTransferButton(this.background.getWidth() - 20, this.background.getHeight() - 20);
            GridPlacer placer = new GridPlacer();
            JeiPlugin.placeRocketParts(39, 8, 1, placer::placeBottom, (RocketPart)((Object)RocketPartsRegistry.ROCKET_PART_NOSE.get()), builder, recipe);
            JeiPlugin.placeRocketParts(30, 26, 2, placer::placeBottom, (RocketPart)((Object)RocketPartsRegistry.ROCKET_PART_BODY.get()), builder, recipe);
            JeiPlugin.placeRocketParts(30, 80, 1, placer::placeRight, (RocketPart)((Object)RocketPartsRegistry.ROCKET_PART_TANK.get()), builder, recipe);
            JeiPlugin.placeRocketParts(12, 80, 1, placer::placeBottom, (RocketPart)((Object)RocketPartsRegistry.ROCKET_PART_FIN_LEFT.get()), builder, recipe);
            JeiPlugin.placeRocketParts(66, 80, 1, placer::placeBottom, (RocketPart)((Object)RocketPartsRegistry.ROCKET_PART_FIN_RIGHT.get()), builder, recipe);
            JeiPlugin.placeRocketParts(39, 98, 1, placer::placeBottom, (RocketPart)((Object)RocketPartsRegistry.ROCKET_PART_ENGINE.get()), builder, recipe);
            IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 127, 73);
            output.addItemStack(recipe.getOutput());
        }

        public RecipeType<WorkbenchingRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends WorkbenchingRecipe> getRecipeClass() {
            return WorkbenchingRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }
    }

    public static class FuelRefineryJeiCategory
    implements IRecipeCategory<FuelRefiningRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "fuel_refinery");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "fuel_refinery"), FuelRefiningRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/fuel_refinery.png");
        private static final Component title = new TranslatableComponent("container.beyond_earth.fuel_refinery");
        public static final int INPUT_TANK_LEFT = 8;
        public static final int INPUT_TANK_TOP = 8;
        public static final int OUTPUT_TANK_LEFT = 74;
        public static final int OUTPUT_TANK_TOP = 8;
        public static final int ENERGY_LEFT = 114;
        public static final int ENERGY_TOP = 8;
        private final JeiPlugin plugin;
        private final IDrawableStatic background;
        private final IDrawable fluidOverlay;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public FuelRefineryJeiCategory(JeiPlugin plugin, IGuiHelper guiHelper) {
            this.plugin = plugin;
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 147, 64).setTextureSize(147, 64).build();
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public void setRecipe(IRecipeLayoutBuilder builder, FuelRefiningRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder inputItem = builder.addSlot(RecipeIngredientRole.INPUT, 25, 9);
            inputItem.addItemStacks(this.plugin.getFluidFullItemStacks(recipe.getInput().getFluids()));
            IRecipeSlotBuilder outputItem = builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 39);
            outputItem.addItemStacks(this.plugin.getFluidFullItemStacks(recipe.getOutput().getFluids()));
            IRecipeSlotBuilder inputTank = builder.addSlot(RecipeIngredientRole.CATALYST, 8, 8);
            inputTank.setFluidRenderer(1, false, 14, 48).setOverlay(this.fluidOverlay, 0, 0);
            inputTank.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getInput().toStacks());
            IRecipeSlotBuilder outputTank = builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 8);
            outputTank.setFluidRenderer(1, false, 14, 48).setOverlay(this.fluidOverlay, 0, 0);
            outputTank.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getOutput().toStacks());
        }

        public void draw(FuelRefiningRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)200)).draw(stack, 114, 8);
        }

        public List<Component> getTooltipStrings(FuelRefiningRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            return Collections.emptyList();
        }

        public RecipeType<FuelRefiningRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelRefiningRecipe> getRecipeClass() {
            return FuelRefiningRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public Rectangle2d getInputTankBounds() {
            return GuiHelper.getFluidTankBounds(8, 8);
        }

        public Rectangle2d getOutputTankBounds() {
            return GuiHelper.getFluidTankBounds(74, 8);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(114, 8);
        }
    }

    public static class RocketTier1JeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rocket_t1");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "rocket_t1"), FuelLoadingRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/rocket_gui.png");
        private static final Component title = ((EntityType)EntitiesRegistry.TIER_1_ROCKET.get()).m_20676_();
        private final IDrawableStatic background;
        private final IDrawable icon;

        public RocketTier1JeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 128, 71).setTextureSize(128, 71).build();
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemsRegistry.TIER_1_ROCKET_ITEM.get()));
        }

        public void setRecipe(IRecipeLayoutBuilder builder, FuelLoadingRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 14, 19);
            input.addItemStacks(recipe.getFuelTagBuckets());
            int capacity = 1000;
            IRecipeSlotBuilder tank = builder.addSlot(RecipeIngredientRole.CATALYST, 66, 12);
            tank.setFluidRenderer(capacity, true, 46, 46);
            tank.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getFluidStacks(capacity));
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public RecipeType getRecipeType() {
            return recipeType;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }
    }

    public static class RocketTier2JeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rocket_t2");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "rocket_t2"), FuelLoadingRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/rocket_gui.png");
        private static final Component title = ((EntityType)EntitiesRegistry.TIER_2_ROCKET.get()).m_20676_();
        private final IDrawableStatic background;
        private final IDrawable icon;

        public RocketTier2JeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 128, 71).setTextureSize(128, 71).build();
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemsRegistry.TIER_2_ROCKET_ITEM.get()));
        }

        public void setRecipe(IRecipeLayoutBuilder builder, FuelLoadingRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 14, 19);
            input.addItemStacks(recipe.getFuelTagBuckets());
            int capacity = 3000;
            IRecipeSlotBuilder tank = builder.addSlot(RecipeIngredientRole.CATALYST, 66, 12);
            tank.setFluidRenderer(capacity, true, 46, 46);
            tank.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getFluidStacks(capacity));
        }

        public RecipeType<FuelLoadingRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }
    }

    public static class RocketTier3JeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rocket_t3");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "rocket_t3"), FuelLoadingRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/rocket_gui.png");
        private static final Component title = ((EntityType)EntitiesRegistry.TIER_3_ROCKET.get()).m_20676_();
        private final IDrawableStatic background;
        private final IDrawable icon;

        public RocketTier3JeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 128, 71).setTextureSize(128, 71).build();
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemsRegistry.TIER_3_ROCKET_ITEM.get()));
        }

        public void setRecipe(IRecipeLayoutBuilder builder, FuelLoadingRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 14, 19);
            input.addItemStacks(recipe.getFuelTagBuckets());
            int capacity = 3000;
            IRecipeSlotBuilder tank = builder.addSlot(RecipeIngredientRole.CATALYST, 66, 12);
            tank.setFluidRenderer(capacity, true, 46, 46);
            tank.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getFluidStacks(capacity));
        }

        public RecipeType<FuelLoadingRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }
    }

    public static class RocketTier4JeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rocket_t4");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "rocket_t4"), FuelLoadingRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/rocket_gui.png");
        private static final Component title = ((EntityType)EntitiesRegistry.TIER_4_ROCKET.get()).m_20676_();
        private final IDrawableStatic background;
        private final IDrawable icon;

        public RocketTier4JeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 128, 71).setTextureSize(128, 71).build();
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemsRegistry.TIER_4_ROCKET_ITEM.get()));
        }

        public void setRecipe(IRecipeLayoutBuilder builder, FuelLoadingRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 14, 19);
            input.addItemStacks(recipe.getFuelTagBuckets());
            int capacity = 3000;
            IRecipeSlotBuilder tank = builder.addSlot(RecipeIngredientRole.CATALYST, 66, 12);
            tank.setFluidRenderer(capacity, true, 46, 46);
            tank.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getFluidStacks(capacity));
        }

        public RecipeType<FuelLoadingRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }
    }

    public static class RoverJeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "rover");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "rover"), FuelLoadingRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/rover.png");
        private static final Component title = ((EntityType)EntitiesRegistry.ROVER.get()).m_20676_();
        private final IDrawableStatic background;
        private final IDrawable fluidOverlay;

        public RoverJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 144, 84).setTextureSize(144, 84).build();
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
        }

        public void setRecipe(IRecipeLayoutBuilder builder, FuelLoadingRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, 8, 60);
            input.addItemStacks(recipe.getFuelTagBuckets());
            int capacity = 3000;
            IRecipeSlotBuilder tank = builder.addSlot(RecipeIngredientRole.INPUT, 9, 8);
            tank.setFluidRenderer(capacity, true, 14, 48).setOverlay(this.fluidOverlay, 0, 0);
            tank.addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getFluidStacks(capacity));
        }

        public RecipeType<FuelLoadingRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }
    }

    public static class SpaceStationJeiCategory
    implements IRecipeCategory<SpaceStationRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("beyond_earth", "space_station");
        public static final RecipeType recipeType = new RecipeType(new ResourceLocation("beyond_earth", "space_station"), SpaceStationRecipe.class);
        public static final ResourceLocation BACKGROUND = new ResourceLocation("beyond_earth", "textures/jei/space_station.png");
        public static final ResourceLocation ICON = new ResourceLocation("beyond_earth", "textures/jei/space_station_icon.png");
        private static final String path = "beyond_earth.space_station";
        private static final Component title = new TranslatableComponent("jei.category.beyond_earth.space_station");
        private static final Component tooltip = new TranslatableComponent("jei.tooltip.beyond_earth.space_station");
        public static final int SLOTS_X_CENTER = 72;
        public static final int SLOTS_Y_TOP = 6;
        public static final int SLOTS_X_OFFSET = 18;
        public static final int SLOTS_Y_OFFSET = 18;
        private final Component[] tooltips = (Component[])Arrays.stream(tooltip.getString().split("\n")).map(TextComponent::new).toArray(Component[]::new);
        private final IDrawableStatic background;
        private final IDrawable icon;
        private final IDrawable slot;

        public SpaceStationJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 144, 51).setTextureSize(144, 51).build();
            this.icon = guiHelper.drawableBuilder(ICON, 0, 0, 16, 16).setTextureSize(16, 16).build();
            this.slot = guiHelper.getSlotDrawable();
        }

        public void setRecipe(IRecipeLayoutBuilder builder, SpaceStationRecipe recipe, IFocusGroup focuses) {
            super.setRecipe(builder, (Object)recipe, focuses);
            NonNullList<IngredientStack> ingredientStacks = recipe.getIngredientStacks();
            int count = ingredientStacks.size();
            for (int i = 0; i < count; ++i) {
                int[] pos = this.getSpaceStationItemPosition(i, count);
                IngredientStack ingredientStack = (IngredientStack)ingredientStacks.get(i);
                IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, pos[0] + 1, pos[1] + 1);
                slot.addItemStacks(Arrays.asList(ingredientStack.getItems()));
            }
        }

        public int[] getSpaceStationItemPosition(int index, int count) {
            int xIndex = index % count;
            int yIndex = index / count;
            int slots_width = count * 18;
            int xPosition = 72 + xIndex * 18 - slots_width / 2;
            int yPosition = 6 + yIndex * 18;
            return new int[]{xPosition, yPosition};
        }

        public void draw(SpaceStationRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
            super.draw((Object)recipe, recipeSlotsView, stack, mouseX, mouseY);
            NonNullList<IngredientStack> ingredientStacks = recipe.getIngredientStacks();
            int count = ingredientStacks.size();
            for (int i = 0; i < count; ++i) {
                int[] pos = this.getSpaceStationItemPosition(i, count);
                this.slot.draw(stack, pos[0], pos[1]);
            }
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = minecraft.f_91062_;
            int tooltipYOffset = this.getSpaceStationItemPosition(ingredientStacks.size() - 1, count)[1] + 18 + 4;
            Component[] tooltips = this.getTooltip();
            for (int i = 0; i < tooltips.length; ++i) {
                Component tooltip = tooltips[i];
                int tooltipWidth = font.m_92852_((FormattedText)tooltip);
                float f = 72 - tooltipWidth / 2;
                Objects.requireNonNull(font);
                font.m_92889_(stack, tooltip, f, (float)(tooltipYOffset + 9 * i), -12566464);
            }
        }

        public RecipeType<SpaceStationRecipe> getRecipeType() {
            return recipeType;
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends SpaceStationRecipe> getRecipeClass() {
            return SpaceStationRecipe.class;
        }

        public Component getTitle() {
            return title;
        }

        public Component[] getTooltip() {
            return this.tooltips;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }
    }

    public static class FuelLoadingRecipe {
        private final List<ItemStack> fuelTagBuckets;
        private final List<Fluid> fluids;

        public FuelLoadingRecipe(List<ItemStack> fuelTagBuckets, List<Fluid> fluids) {
            this.fuelTagBuckets = Collections.unmodifiableList(fuelTagBuckets);
            this.fluids = Collections.unmodifiableList(fluids);
        }

        public List<ItemStack> getFuelTagBuckets() {
            return this.fuelTagBuckets;
        }

        public List<FluidStack> getFluidStacks(int amount) {
            return this.getFluid().stream().map(f -> new FluidStack(f, amount)).collect(Collectors.toList());
        }

        public List<Fluid> getFluid() {
            return this.fluids;
        }
    }
}

