/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.machines.tile;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.NetworkEvent;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeType;
import net.mrscauthd.beyond_earth.crafting.BeyondEarthRecipeTypes;
import net.mrscauthd.beyond_earth.crafting.OxygenMakingRecipeAbstract;
import net.mrscauthd.beyond_earth.guis.screens.oxygenbubbledistributor.OxygenBubbleDistributorGui;
import net.mrscauthd.beyond_earth.machines.tile.NamedComponentRegistry;
import net.mrscauthd.beyond_earth.machines.tile.OxygenMakingBlockEntity;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystemEnergyCommon;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystemRegistry;
import net.mrscauthd.beyond_earth.registries.BlockEntitiesRegistry;
import net.mrscauthd.beyond_earth.registries.EffectsRegistry;

public class OxygenBubbleDistributorBlockEntity
extends OxygenMakingBlockEntity {
    public static final int ENERGY_PER_TICK = 1;
    public static final String KEY_TIMER = "timer";
    public static final String KEY_RANGE = "range";
    public static final String KEY_WORKINGAREA_VISIBLE = "workingAreaVisible";
    public static final int RANGE_MAX = 15;
    public static final int RANGE_MIN = 1;
    public static final int MAX_TIMER = 4;

    public OxygenBubbleDistributorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.OXYGEN_BUBBLE_DISTRIBUTOR_BLOCK_ENTITY.get(), pos, state);
        this.setWorkingAreaVisible(false);
    }

    @Override
    protected boolean canActivated() {
        if (this.getOutputTank().getOxygenStored() >= this.getOxygenUsing(this.getRange())) {
            return true;
        }
        return super.canActivated();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82377_(32.0, 32.0, 32.0);
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new OxygenBubbleDistributorGui.GuiContainer(id, inventory, this);
    }

    @Override
    protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
        super.createEnergyStorages(registry);
        registry.put(this.createEnergyStorageCommon());
    }

    @Override
    protected void tickProcessing() {
        super.tickProcessing();
        this.tickDistributeTimer();
    }

    private void tickDistributeTimer() {
        if (this.getTimer() >= this.getMaxTimer()) {
            this.setTimer(0);
            this.distribute();
        }
        this.setTimer(this.getTimer() + 1);
    }

    private void distribute() {
        double range;
        int oxygenUsing;
        IOxygenStorage oxygenStorage = this.getOutputTank();
        if (oxygenStorage.extractOxygen(oxygenUsing = this.getOxygenUsing(range = (double)this.getRange()), true) == oxygenUsing && (this.isProcessedInThisTick() || this.consumePowerForOperation() != null)) {
            oxygenStorage.extractOxygen(oxygenUsing, false);
            this.spawnOxygenBubble(range);
        }
    }

    private void spawnOxygenBubble(double range) {
        Level level = this.m_58904_();
        List entities = level.m_45976_(Mob.class, this.getWorkingArea(range));
        List players = level.m_45976_(Player.class, this.getWorkingArea(range));
        for (Mob entity : entities) {
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.OXYGEN_EFFECT.get(), 48, 0, false, false));
        }
        for (Mob entity : players) {
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.OXYGEN_EFFECT.get(), 48, 0, false, false));
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = new AABB(this.m_58899_()).m_82399_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, center.f_82479_, center.f_82480_ + 0.5, center.f_82481_, 1, 0.1, 0.1, 0.1, 0.001);
        }
        this.setProcessedInThisTick();
    }

    public int getMaxTimer() {
        return 4;
    }

    public int getTimer() {
        return this.getTileData().m_128451_(KEY_TIMER);
    }

    public void setTimer(int timer) {
        timer = Math.max(timer, 0);
        if (this.getTimer() != timer) {
            this.getTileData().m_128405_(KEY_TIMER, timer);
            this.m_6596_();
        }
    }

    public int getOxygenUsing(double range) {
        return (int)range + 1;
    }

    public int getRange() {
        return Math.max(this.getTileData().m_128451_(KEY_RANGE), 1);
    }

    public void setRange(int range) {
        range = Math.min(Math.max(range, 1), 15);
        if (this.getRange() != range) {
            this.getTileData().m_128405_(KEY_RANGE, range);
            this.m_6596_();
        }
    }

    public boolean isWorkingAreaVisible() {
        return this.getTileData().m_128471_(KEY_WORKINGAREA_VISIBLE);
    }

    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.getTileData().m_128379_(KEY_WORKINGAREA_VISIBLE, visible);
            this.m_6596_();
        }
    }

    public AABB getWorkingArea(double range) {
        return this.getWorkingArea(this.m_58899_(), range);
    }

    public AABB getWorkingArea(BlockPos pos, double range) {
        return new AABB(pos).m_82400_(range).m_82386_(0.0, range, 0.0);
    }

    @Override
    protected void createPowerSystems(PowerSystemRegistry map) {
        super.createPowerSystems(map);
        map.put(new PowerSystemEnergyCommon(this){

            @Override
            public int getBasePowerForOperation() {
                return OxygenBubbleDistributorBlockEntity.this.getBasePowerForOperation();
            }
        });
    }

    public int getBasePowerForOperation() {
        return 1;
    }

    @Override
    public BeyondEarthRecipeType<? extends OxygenMakingRecipeAbstract> getRecipeType() {
        return BeyondEarthRecipeTypes.OXYGEN_BUBBLE_DISTRIBUTING;
    }

    public static class ChangeWorkingAreaVisibleMessage {
        private BlockPos blockPos = BlockPos.f_121853_;
        private boolean visible = false;

        public ChangeWorkingAreaVisibleMessage() {
        }

        public ChangeWorkingAreaVisibleMessage(BlockPos pos, boolean visible) {
            this.setBlockPos(pos);
            this.setVisible(visible);
        }

        public ChangeWorkingAreaVisibleMessage(FriendlyByteBuf buffer) {
            this.setBlockPos(buffer.m_130135_());
            this.setVisible(buffer.readBoolean());
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public static ChangeWorkingAreaVisibleMessage decode(FriendlyByteBuf buffer) {
            return new ChangeWorkingAreaVisibleMessage(buffer);
        }

        public static void encode(ChangeWorkingAreaVisibleMessage message, FriendlyByteBuf buffer) {
            buffer.m_130064_(message.getBlockPos());
            buffer.writeBoolean(message.isVisible());
        }

        public static void handle(ChangeWorkingAreaVisibleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            OxygenBubbleDistributorBlockEntity blockEntity = (OxygenBubbleDistributorBlockEntity)context.getSender().f_19853_.m_7702_(message.getBlockPos());
            blockEntity.setWorkingAreaVisible(message.isVisible());
            context.setPacketHandled(true);
        }
    }

    public static class ChangeRangeMessage {
        private BlockPos blockPos = BlockPos.f_121853_;
        private boolean direction = false;

        public ChangeRangeMessage() {
        }

        public ChangeRangeMessage(BlockPos pos, boolean direction) {
            this.setBlockPos(pos);
            this.setDirection(direction);
        }

        public ChangeRangeMessage(FriendlyByteBuf buffer) {
            this.setBlockPos(buffer.m_130135_());
            this.setDirection(buffer.readBoolean());
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public boolean getDirection() {
            return this.direction;
        }

        public void setDirection(boolean direction) {
            this.direction = direction;
        }

        public static ChangeRangeMessage decode(FriendlyByteBuf buffer) {
            return new ChangeRangeMessage(buffer);
        }

        public static void encode(ChangeRangeMessage message, FriendlyByteBuf buffer) {
            buffer.m_130064_(message.getBlockPos());
            buffer.writeBoolean(message.getDirection());
        }

        public static void handle(ChangeRangeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            OxygenBubbleDistributorBlockEntity blockEntity = (OxygenBubbleDistributorBlockEntity)context.getSender().f_19853_.m_7702_(message.getBlockPos());
            int prev = blockEntity.getRange();
            int next = prev + (message.getDirection() ? 1 : -1);
            blockEntity.setRange(next);
            context.setPacketHandled(true);
        }
    }
}

