/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.machines.tile;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.mrscauthd.beyond_earth.capabilities.fluid.FluidHandlerWrapper;
import net.mrscauthd.beyond_earth.fluids.FluidUtil2;
import net.mrscauthd.beyond_earth.guis.screens.waterpump.WaterPumpGui;
import net.mrscauthd.beyond_earth.machines.WaterPump;
import net.mrscauthd.beyond_earth.machines.tile.AbstractMachineBlockEntity;
import net.mrscauthd.beyond_earth.machines.tile.NamedComponentRegistry;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystemEnergyCommon;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystemRegistry;
import net.mrscauthd.beyond_earth.registries.BlockEntitiesRegistry;

public class WaterPumpBlockEntity
extends AbstractMachineBlockEntity {
    public static final int TRANSFER_PER_TICK = 10;
    public static final ResourceLocation WATER_TANK = new ResourceLocation("beyond_earth", "water_tank");
    public static final int TANK_CAPACITY = 6000;
    public double WATER_TIMER = 0.0;
    private FluidTank waterTank;

    public WaterPumpBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.WATER_PUMP_BLOCK_ENTITY.get(), pos, state);
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new WaterPumpGui.GuiContainer(id, inventory, this);
    }

    @Override
    protected void tickProcessing() {
        int transferPerTick;
        IFluidHandler fluidHandler;
        BlockEntity ejectBlockEntity;
        BlockPos pos = this.m_58899_();
        BlockPos pickupPos = new BlockPos(pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_());
        if (this.f_58857_.m_6425_(pickupPos) == Fluids.f_76193_.m_76068_(false) && this.f_58857_.m_8055_(pickupPos).m_60713_(Blocks.f_49990_) && this.hasSpaceInWaterTank(this.getWaterTank().getFluid().getAmount()) && this.consumePowerForOperation() != null) {
            this.WATER_TIMER += 1.0;
            if (this.WATER_TIMER > 10.0) {
                this.f_58857_.m_7731_(pickupPos, Blocks.f_50016_.m_49966_(), 3);
                this.getWaterTank().fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
                this.WATER_TIMER = 0.0;
            }
        }
        if (this.getWaterTank().getFluid().getAmount() > 1 && (ejectBlockEntity = this.f_58857_.m_7702_(new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_()))) != null && (fluidHandler = (IFluidHandler)ejectBlockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).orElse(null)) != null && FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.waterTank, (int)(transferPerTick = this.getTransferPerTick()), (boolean)false).getAmount() == transferPerTick) {
            FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.waterTank, (int)transferPerTick, (boolean)true);
        }
    }

    public int getTransferPerTick() {
        return 10;
    }

    public boolean hasSpaceInWaterTank(int water) {
        return this.hasSpaceIn(water, this.getWaterTank().getFluid());
    }

    public boolean hasSpaceIn(int water, FluidStack storage) {
        return water < 5001;
    }

    @Override
    public <T> LazyOptional<T> getCapabilityFluidHandler(Capability<T> capability, Direction facing) {
        if (facing == null || facing == Direction.UP) {
            return super.getCapabilityFluidHandler(capability, facing).lazyMap(handler -> new FluidHandlerWrapper((IFluidHandler)handler, true, false)).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public <T> LazyOptional<T> getCapabilityEnergy(Capability<T> capability, Direction facing) {
        BlockState blockState = this.m_58900_();
        if (blockState.m_61138_((Property)WaterPump.FACING)) {
            Direction blockDirection = (Direction)blockState.m_61143_((Property)WaterPump.FACING);
            if (facing == null || facing == blockDirection) {
                return super.getCapabilityEnergy(capability, facing);
            }
        }
        return LazyOptional.empty();
    }

    @Override
    protected void createPowerSystems(PowerSystemRegistry map) {
        super.createPowerSystems(map);
        map.put(new PowerSystemEnergyCommon(this){

            @Override
            public int getBasePowerForOperation() {
                return WaterPumpBlockEntity.this.getBasePowerForOperation();
            }
        });
    }

    @Override
    protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
        super.createEnergyStorages(registry);
        registry.put(this.createEnergyStorageCommon());
    }

    public int getBasePowerForOperation() {
        return 1;
    }

    @Override
    protected void createFluidHandlers(NamedComponentRegistry<IFluidHandler> registry) {
        super.createFluidHandlers(registry);
        this.waterTank = (FluidTank)registry.computeIfAbsent(this.getTankName(), k -> this.creatTank((ResourceLocation)k));
    }

    protected int getInitialTankCapacity(ResourceLocation name) {
        return 6000;
    }

    protected Predicate<FluidStack> getInitialTankValidator(ResourceLocation name) {
        Fluid fluid = this.getTankFluid(name);
        return fluid != null ? fs -> FluidUtil2.isSame(fs, fluid) : null;
    }

    protected Fluid getTankFluid(ResourceLocation name) {
        if (name.equals((Object)this.getTankName())) {
            return Fluids.f_76193_;
        }
        return null;
    }

    protected FluidTank creatTank(ResourceLocation name) {
        return new FluidTank(this.getInitialTankCapacity(name), this.getInitialTankValidator(name)){

            protected void onContentsChanged() {
                super.onContentsChanged();
                WaterPumpBlockEntity.this.m_6596_();
            }
        };
    }

    public ResourceLocation getTankName() {
        return WATER_TANK;
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    @Override
    public boolean hasSpaceInOutput() {
        return false;
    }
}

