/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.blocks.modifierblock;

import com.yyon.grapplinghook.blocks.modifierblock.TileEntityGrappleModifier;
import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.items.GrapplehookItem;
import com.yyon.grapplinghook.items.upgrades.BaseUpgradeItem;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import com.yyon.grapplinghook.utils.Vec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BlockGrappleModifier
extends BaseEntityBlock {
    public BlockGrappleModifier() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityGrappleModifier(pos, state);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder lootctx) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)this.m_5456_()));
        BlockEntity ent = (BlockEntity)lootctx.m_78982_(LootContextParams.f_81462_);
        if (ent == null || !(ent instanceof TileEntityGrappleModifier)) {
            return drops;
        }
        TileEntityGrappleModifier tileent = (TileEntityGrappleModifier)ent;
        for (GrappleCustomization.upgradeCategories category : GrappleCustomization.upgradeCategories.values()) {
            if (!tileent.unlockedCategories.containsKey((Object)category) || !tileent.unlockedCategories.get((Object)category).booleanValue()) continue;
            drops.add(new ItemStack((ItemLike)category.getItem()));
        }
        return drops;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult raytraceresult) {
        ItemStack helditemstack = playerIn.m_21120_(InteractionHand.MAIN_HAND);
        Item helditem = helditemstack.m_41720_();
        if (helditem instanceof BaseUpgradeItem) {
            if (!worldIn.f_46443_) {
                BlockEntity ent = worldIn.m_7702_(pos);
                TileEntityGrappleModifier tileent = (TileEntityGrappleModifier)ent;
                GrappleCustomization.upgradeCategories category = ((BaseUpgradeItem)helditem).f_41377_;
                if (category != null) {
                    if (tileent.isUnlocked(category)) {
                        playerIn.m_6352_((Component)new TextComponent("Already has upgrade: " + category.getName()), playerIn.m_142081_());
                    } else {
                        if (!playerIn.m_7500_()) {
                            playerIn.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                        }
                        tileent.unlockCategory(category);
                        playerIn.m_6352_((Component)new TextComponent("Applied upgrade: " + category.getName()), playerIn.m_142081_());
                    }
                }
            }
        } else if (helditem instanceof GrapplehookItem) {
            if (!worldIn.f_46443_) {
                BlockEntity ent = worldIn.m_7702_(pos);
                TileEntityGrappleModifier tileent = (TileEntityGrappleModifier)ent;
                GrappleCustomization custom = tileent.customization;
                CommonSetup.grapplingHookItem.setCustomOnServer(helditemstack, custom, playerIn);
                playerIn.m_6352_((Component)new TextComponent("Applied configuration"), playerIn.m_142081_());
            }
        } else if (helditem == Items.f_42475_) {
            if (!worldIn.f_46443_) {
                if (GrappleConfig.getConf().longfallboots.longfallbootsrecipe) {
                    Map enchantments;
                    boolean gaveitem = false;
                    if (helditemstack.m_41793_() && (enchantments = EnchantmentHelper.m_44831_((ItemStack)helditemstack)).containsKey(Enchantments.f_44967_) && (Integer)enchantments.get(Enchantments.f_44967_) >= 4) {
                        ItemStack newitemstack = new ItemStack((ItemLike)CommonSetup.longFallBootsItem);
                        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)newitemstack);
                        playerIn.m_21008_(InteractionHand.MAIN_HAND, newitemstack);
                        gaveitem = true;
                    }
                    if (!gaveitem) {
                        playerIn.m_6352_((Component)new TextComponent("Right click with diamond boots enchanted with feather falling IV to get long fall boots"), playerIn.m_142081_());
                    }
                } else {
                    playerIn.m_6352_((Component)new TextComponent("Making long fall boots this way was disabled in the config. It probably has been replaced by a crafting recipe."), playerIn.m_142081_());
                }
            }
        } else if (helditem == Items.f_42415_) {
            this.easterEgg(state, worldIn, pos, playerIn, hand, raytraceresult);
        } else if (worldIn.f_46443_) {
            BlockEntity ent = worldIn.m_7702_(pos);
            TileEntityGrappleModifier tileent = (TileEntityGrappleModifier)ent;
            ClientProxyInterface.proxy.openModifierScreen(tileent);
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void easterEgg(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult raytraceresult) {
        int spacing = 3;
        Vec[] positions = new Vec[]{new Vec(-spacing * 2, 0.0, 0.0), new Vec(-spacing, 0.0, 0.0), new Vec(0.0, 0.0, 0.0), new Vec(spacing, 0.0, 0.0), new Vec(2 * spacing, 0.0, 0.0)};
        int[] colors = new int[]{6017018, 16100281, 0xFFFFFF, 16100281, 6017018};
        for (int i = 0; i < positions.length; ++i) {
            Vec newpos = new Vec((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            Vec toPlayer = Vec.positionVec((Entity)playerIn).sub(newpos);
            double angle = toPlayer.length() == 0.0 ? 0.0 : toPlayer.getYaw();
            newpos = newpos.add(positions[i].rotateYaw(Math.toRadians(angle)));
            CompoundTag explosion = new CompoundTag();
            explosion.m_128344_("Type", (byte)FireworkRocketItem.Shape.SMALL_BALL.m_41236_());
            explosion.m_128379_("Trail", true);
            explosion.m_128379_("Flicker", false);
            explosion.m_128385_("Colors", new int[]{colors[i]});
            explosion.m_128385_("FadeColors", new int[0]);
            ListTag list = new ListTag();
            list.add((Object)explosion);
            CompoundTag fireworks = new CompoundTag();
            fireworks.m_128365_("Explosions", (Tag)list);
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Fireworks", (Tag)fireworks);
            ItemStack stack = new ItemStack((ItemLike)Items.f_42688_);
            stack.m_41751_(nbt);
            FireworkRocketEntity firework = new FireworkRocketEntity(worldIn, (Entity)playerIn, newpos.x, newpos.y, newpos.z, stack);
            CompoundTag fireworksave = new CompoundTag();
            firework.m_7380_(fireworksave);
            fireworksave.m_128405_("LifeTime", 15);
            firework.m_7378_(fireworksave);
            worldIn.m_7967_((Entity)firework);
        }
    }
}

