/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.blocks.modifierblock;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.yyon.grapplinghook.blocks.modifierblock.TileEntityGrappleModifier;
import com.yyon.grapplinghook.client.ClientProxyInterface;
import com.yyon.grapplinghook.utils.GrappleCustomization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuiModifier
extends Screen {
    private static final ResourceLocation texture = new ResourceLocation("grapplemod", "textures/gui/guimodifier_bg.png");
    int xSize = 221;
    int ySize = 221;
    protected int guiLeft;
    protected int guiTop;
    int posy;
    int id;
    HashMap<AbstractWidget, String> options;
    TileEntityGrappleModifier tileEnt;
    GrappleCustomization customization;
    GrappleCustomization.upgradeCategories category = null;

    public GuiModifier(TileEntityGrappleModifier tileent) {
        super((Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.title.desc")));
        this.tileEnt = tileent;
        this.customization = tileent.customization;
    }

    public void m_7856_() {
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.mainScreen();
    }

    public void mainScreen() {
        this.clearScreen();
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.close.desc")), new Button.OnPress(){

            public void m_93750_(Button p_onPress_1_) {
                GuiModifier.this.m_7379_();
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + this.xSize - 50 - 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.reset.desc")), new Button.OnPress(){

            public void m_93750_(Button p_onPress_1_) {
                GuiModifier.this.customization = new GrappleCustomization();
                GuiModifier.this.mainScreen();
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10 + 75, this.guiTop + this.ySize - 20 - 10, 50, 20, (Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.helpbutton.desc")), new Button.OnPress(){

            public void m_93750_(Button p_onPress_1_) {
                GuiModifier.this.helpScreen();
            }
        }));
        int y = 0;
        int x = 0;
        for (int i = 0; i < GrappleCustomization.upgradeCategories.size(); ++i) {
            GrappleCustomization.upgradeCategories category = GrappleCustomization.upgradeCategories.fromInt(i);
            if (category == GrappleCustomization.upgradeCategories.LIMITS) continue;
            if (i == GrappleCustomization.upgradeCategories.size() / 2) {
                y = 0;
                ++x;
            }
            this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10 + 105 * x, this.guiTop + 15 + 30 * y, 95, 20, (Component)new TextComponent(category.getName()), (Button.OnPress)new PressCategory(category)));
            ++y;
        }
        this.m_142416_((GuiEventListener)new TextWidget((Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.apply.desc")), this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10 - 10));
    }

    public void clearScreen() {
        this.category = null;
        this.posy = 10;
        this.id = 10;
        this.options = new HashMap();
        this.m_169413_();
        this.m_142416_((GuiEventListener)new BackgroundWidget(this.guiLeft, this.guiTop, this.xSize, this.ySize));
    }

    public void notAllowedScreen(GrappleCustomization.upgradeCategories category) {
        this.clearScreen();
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.back.desc")), (Button.OnPress)new PressBack()));
        this.category = category;
        this.m_142416_((GuiEventListener)new TextWidget((Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.unlock1.desc")), this.guiLeft + 10, this.guiTop + 10));
        this.m_142416_((GuiEventListener)new TextWidget((Component)new TextComponent(this.category.getName()), this.guiLeft + 10, this.guiTop + 25));
        this.m_142416_((GuiEventListener)new TextWidget((Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.unlock2.desc")), this.guiLeft + 10, this.guiTop + 40));
        this.m_142416_((GuiEventListener)new TextWidget((Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.unlock3.desc")), this.guiLeft + 10, this.guiTop + 55));
        this.m_142416_((GuiEventListener)new TextWidget(new ItemStack((ItemLike)this.category.getItem()).m_41611_(), this.guiLeft + 10, this.guiTop + 70));
        this.m_142416_((GuiEventListener)new TextWidget((Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.unlock4.desc")), this.guiLeft + 10, this.guiTop + 85));
    }

    public void helpScreen() {
        this.clearScreen();
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.back.desc")), (Button.OnPress)new PressBack()));
        this.m_142416_((GuiEventListener)new TextWidget((Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.help.desc")), this.guiLeft + 10, this.guiTop + 10));
    }

    public void addCheckbox(String option) {
        String text = ClientProxyInterface.proxy.localize(this.customization.getName(option));
        String desc = ClientProxyInterface.proxy.localize(this.customization.getDescription(option));
        GuiCheckbox checkbox = new GuiCheckbox(10 + this.guiLeft, this.posy + this.guiTop, this.xSize - 20, 20, (Component)new TextComponent(text), this.customization.getBoolean(option), option, (Component)new TextComponent(desc));
        this.posy += 22;
        this.m_142416_((GuiEventListener)checkbox);
        this.options.put((AbstractWidget)checkbox, option);
    }

    public void addSlider(String option) {
        double d = this.customization.getDouble(option);
        d = Math.floor(d * 10.0 + 0.5) / 10.0;
        double max = this.customization.getMax(option, this.getLimits());
        double min = this.customization.getMin(option, this.getLimits());
        String text = ClientProxyInterface.proxy.localize(this.customization.getName(option));
        String desc = ClientProxyInterface.proxy.localize(this.customization.getDescription(option));
        GuiSlider slider = new GuiSlider(10 + this.guiLeft, this.posy + this.guiTop, this.xSize - 20, 20, (Component)new TextComponent(text), min, max, d, option, (Component)new TextComponent(desc));
        this.posy += 22;
        this.m_142416_((GuiEventListener)slider);
        this.options.put((AbstractWidget)slider, option);
    }

    public void showCategoryScreen(GrappleCustomization.upgradeCategories category) {
        this.clearScreen();
        this.m_142416_((GuiEventListener)new Button(this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, (Component)new TextComponent(ClientProxyInterface.proxy.localize("grapplemodifier.back.desc")), (Button.OnPress)new PressBack()));
        this.category = category;
        if (category == GrappleCustomization.upgradeCategories.ROPE) {
            this.addSlider("maxlen");
            this.addCheckbox("phaserope");
            this.addCheckbox("sticky");
        } else if (category == GrappleCustomization.upgradeCategories.THROW) {
            this.addSlider("hookgravity");
            this.addSlider("throwspeed");
            this.addCheckbox("reelin");
            this.addSlider("verticalthrowangle");
            this.addSlider("sneakingverticalthrowangle");
            this.addCheckbox("detachonkeyrelease");
        } else if (category == GrappleCustomization.upgradeCategories.MOTOR) {
            this.addCheckbox("motor");
            this.addSlider("motormaxspeed");
            this.addSlider("motoracceleration");
            this.addCheckbox("motorwhencrouching");
            this.addCheckbox("motorwhennotcrouching");
            this.addCheckbox("smartmotor");
            this.addCheckbox("motordampener");
            this.addCheckbox("pullbackwards");
        } else if (category == GrappleCustomization.upgradeCategories.SWING) {
            this.addSlider("playermovementmult");
        } else if (category == GrappleCustomization.upgradeCategories.STAFF) {
            this.addCheckbox("enderstaff");
        } else if (category == GrappleCustomization.upgradeCategories.FORCEFIELD) {
            this.addCheckbox("repel");
            this.addSlider("repelforce");
        } else if (category == GrappleCustomization.upgradeCategories.MAGNET) {
            this.addCheckbox("attract");
            this.addSlider("attractradius");
        } else if (category == GrappleCustomization.upgradeCategories.DOUBLE) {
            this.addCheckbox("doublehook");
            this.addCheckbox("smartdoublemotor");
            this.addSlider("angle");
            this.addSlider("sneakingangle");
            this.addCheckbox("oneropepull");
        } else if (category == GrappleCustomization.upgradeCategories.ROCKET) {
            this.addCheckbox("rocket");
            this.addSlider("rocket_force");
            this.addSlider("rocket_active_time");
            this.addSlider("rocket_refuel_ratio");
            this.addSlider("rocket_vertical_angle");
        }
        this.updateEnabled();
    }

    public void m_7379_() {
        this.tileEnt.setCustomizationClient(this.customization);
        super.m_7379_();
    }

    public void updateEnabled() {
        for (AbstractWidget b : this.options.keySet()) {
            String option = this.options.get(b);
            boolean enabled = true;
            Object desc = ClientProxyInterface.proxy.localize(this.customization.getDescription(option));
            if (!this.customization.isOptionValid(option)) {
                desc = ClientProxyInterface.proxy.localize("grapplemodifier.incompatability.desc") + "\n" + (String)desc;
                enabled = false;
            }
            int level = this.customization.optionEnabled(option);
            if (this.getLimits() < level) {
                desc = level == 1 ? ClientProxyInterface.proxy.localize("grapplemodifier.limits.desc") + "\n" + (String)desc : ClientProxyInterface.proxy.localize("grapplemodifier.locked.desc") + "\n" + (String)desc;
                enabled = false;
            }
            b.f_93623_ = enabled;
            if (b instanceof GuiSlider) {
                ((GuiSlider)b).tooltip = new TextComponent((String)desc);
                b.m_93650_(enabled ? 1.0f : 0.5f);
            }
            if (!(b instanceof GuiCheckbox)) continue;
            ((GuiCheckbox)b).tooltip = new TextComponent((String)desc);
            b.m_93650_(enabled ? 1.0f : 0.5f);
        }
    }

    public int getLimits() {
        if (this.tileEnt.isUnlocked(GrappleCustomization.upgradeCategories.LIMITS) || Minecraft.m_91087_().f_91074_.m_7500_()) {
            return 1;
        }
        return 0;
    }

    class PressCategory
    implements Button.OnPress {
        GrappleCustomization.upgradeCategories category;

        public PressCategory(GrappleCustomization.upgradeCategories category) {
            this.category = category;
        }

        public void m_93750_(Button p_onPress_1_) {
            boolean unlocked;
            boolean bl = unlocked = GuiModifier.this.tileEnt.isUnlocked(this.category) || Minecraft.m_91087_().f_91074_.m_7500_();
            if (unlocked) {
                GuiModifier.this.showCategoryScreen(this.category);
            } else {
                GuiModifier.this.notAllowedScreen(this.category);
            }
        }
    }

    class TextWidget
    extends AbstractWidget {
        public TextWidget(int p_i232254_1_, int p_i232254_2_, int p_i232254_3_, int p_i232254_4_, Component p_i232254_5_) {
            super(p_i232254_1_, p_i232254_2_, p_i232254_3_, p_i232254_4_, p_i232254_5_);
        }

        public TextWidget(Component text, int x, int y) {
            this(x, y, 50, 15 * text.getString().split("\n").length + 5, text);
        }

        public void m_6303_(PoseStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontrenderer = minecraft.f_91062_;
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69482_();
            int j = this.getFGColor();
            int lineno = 0;
            for (String s : this.m_6035_().getString().split("\n")) {
                TextWidget.m_93243_((PoseStack)p_230431_1_, (Font)fontrenderer, (Component)new TextComponent(s), (int)this.f_93620_, (int)(this.f_93621_ + lineno * 15), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
                ++lineno;
            }
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    class BackgroundWidget
    extends AbstractWidget {
        public BackgroundWidget(int p_i232254_1_, int p_i232254_2_, int p_i232254_3_, int p_i232254_4_, Component p_i232254_5_) {
            super(p_i232254_1_, p_i232254_2_, p_i232254_3_, p_i232254_4_, p_i232254_5_);
            this.f_93623_ = false;
        }

        public BackgroundWidget(int x, int y, int w, int h) {
            this(x, y, w, h, (Component)new TextComponent(""));
        }

        public void m_6303_(PoseStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.m_93228_(p_230431_1_, this.f_93620_, this.f_93621_, 0, 0, this.f_93618_, this.f_93619_);
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    class PressBack
    implements Button.OnPress {
        PressBack() {
        }

        public void m_93750_(Button p_onPress_1_) {
            GuiModifier.this.mainScreen();
        }
    }

    class GuiCheckbox
    extends Checkbox {
        String option;
        public Component tooltip;

        public GuiCheckbox(int x, int y, int w, int h, Component text, boolean val, String option, Component tooltip) {
            super(x, y, w, h, text, val);
            this.option = option;
            this.tooltip = tooltip;
        }

        public void m_5691_() {
            super.m_5691_();
            GuiModifier.this.customization.setBoolean(this.option, this.m_93840_());
            GuiModifier.this.updateEnabled();
        }

        public void m_6303_(PoseStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            super.m_6303_(p_230431_1_, p_230431_2_, p_230431_3_, p_230431_4_);
            if (this.f_93622_) {
                String tooltiptext = this.tooltip.getString();
                ArrayList<TextComponent> lines = new ArrayList<TextComponent>();
                for (String line : tooltiptext.split("\n")) {
                    lines.add(new TextComponent(line));
                }
                GuiModifier.this.m_169388_(p_230431_1_, lines, Optional.empty(), p_230431_2_, p_230431_3_);
            }
        }
    }

    class GuiSlider
    extends AbstractSliderButton {
        double min;
        double max;
        double val;
        String text;
        String option;
        public Component tooltip;

        public GuiSlider(int x, int y, int w, int h, Component text, double min, double max, double val, String option, Component tooltip) {
            super(x, y, w, h, text, (val - min) / (max - min));
            this.min = min;
            this.max = max;
            this.val = val;
            this.text = text.getString();
            this.option = option;
            this.tooltip = tooltip;
            this.m_5695_();
        }

        protected void m_5695_() {
            this.m_93666_((Component)new TextComponent(this.text + ": " + String.format("%.1f", this.val)));
        }

        protected void m_5697_() {
            this.val = this.f_93577_ * (this.max - this.min) + this.min;
            GuiModifier.this.customization.setDouble(this.option, this.val);
        }

        public void m_6303_(PoseStack p_230431_1_, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            super.m_6303_(p_230431_1_, p_230431_2_, p_230431_3_, p_230431_4_);
            if (this.f_93622_) {
                String tooltiptext = this.tooltip.getString();
                ArrayList<TextComponent> lines = new ArrayList<TextComponent>();
                for (String line : tooltiptext.split("\n")) {
                    lines.add(new TextComponent(line));
                }
                GuiModifier.this.m_169388_(p_230431_1_, lines, Optional.empty(), p_230431_2_, p_230431_3_);
            }
        }
    }
}

