/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.grapplemod;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public abstract class BaseMessageServer {
    public BaseMessageServer(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public BaseMessageServer() {
    }

    public abstract void decode(FriendlyByteBuf var1);

    public abstract void encode(FriendlyByteBuf var1);

    public abstract void processMessage(NetworkEvent.Context var1);

    public void onMessageReceived(Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        if (sideReceived != LogicalSide.SERVER) {
            grapplemod.LOGGER.warn("message received on wrong side:" + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            grapplemod.LOGGER.warn("EntityPlayerMP was null when message was received");
        }
        ctx.enqueueWork(() -> this.processMessage(ctx));
    }
}

