/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.items.KeypressItem;
import com.yyon.grapplinghook.network.BaseMessageServer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class KeypressMessage
extends BaseMessageServer {
    KeypressItem.Keys key;
    boolean isDown;

    public KeypressMessage(FriendlyByteBuf buf) {
        super(buf);
    }

    public KeypressMessage(KeypressItem.Keys thekey, boolean isDown) {
        this.key = thekey;
        this.isDown = isDown;
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.key = KeypressItem.Keys.values()[buf.readInt()];
        this.isDown = buf.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.key.ordinal());
        buf.writeBoolean(this.isDown);
    }

    @Override
    public void processMessage(NetworkEvent.Context ctx) {
        ServerPlayer player = ctx.getSender();
        if (player != null) {
            Item item;
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (stack != null && (item = stack.m_41720_()) instanceof KeypressItem) {
                if (this.isDown) {
                    ((KeypressItem)item).onCustomKeyDown(stack, (Player)player, this.key, true);
                } else {
                    ((KeypressItem)item).onCustomKeyUp(stack, (Player)player, this.key, true);
                }
                return;
            }
            stack = player.m_21120_(InteractionHand.OFF_HAND);
            if (stack != null && (item = stack.m_41720_()) instanceof KeypressItem) {
                if (this.isDown) {
                    ((KeypressItem)item).onCustomKeyDown(stack, (Player)player, this.key, false);
                } else {
                    ((KeypressItem)item).onCustomKeyUp(stack, (Player)player, this.key, false);
                }
                return;
            }
        }
    }
}

