/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public abstract class TextLogger {
    public final List<MutableComponent> logText = new ArrayList<MutableComponent>();
    protected final String tag;

    protected TextLogger(String tagName) {
        this.tag = tagName;
    }

    public final void clear() {
        this.logText.clear();
    }

    protected final void AddLog(MutableComponent text) {
        if (text != null) {
            this.logText.add(text);
            this.fitToSizeLimit();
        }
    }

    public void write(CompoundTag compound) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.logText.size(); ++i) {
            Component text = (Component)this.logText.get(i);
            CompoundTag thisCompound = new CompoundTag();
            thisCompound.m_128359_("value", Component.Serializer.m_130703_((Component)text));
            list.add((Object)thisCompound);
        }
        compound.m_128365_(this.tag, (Tag)list);
    }

    public void read(CompoundTag compound) {
        if (compound.m_128425_(this.tag, 9)) {
            ListTag list = compound.m_128437_(this.tag, 10);
            this.logText.clear();
            for (int i = 0; i < list.size(); ++i) {
                String jsonText = list.m_128728_(i).m_128461_("value");
                MutableComponent text = Component.Serializer.m_130701_((String)jsonText);
                if (text == null) continue;
                this.logText.add(text);
            }
            this.fitToSizeLimit();
        }
    }

    public final void fitToSizeLimit() {
        while (this.logText.size() > (Integer)Config.SERVER.logLimit.get() && this.logText.size() > 0) {
            this.logText.remove(0);
        }
    }

    public static Component getCreativeText(boolean isCreative) {
        return isCreative ? new TranslatableComponent("log.shoplog.creative").m_130940_(ChatFormatting.YELLOW) : new TextComponent("");
    }

    public static Component getPlayerText(PlayerReference player) {
        return new TextComponent(player.lastKnownName()).m_130940_(ChatFormatting.GREEN);
    }

    @Deprecated
    public static Component getCostText(boolean isFree, CoinValue cost) {
        return TextLogger.getCostText(cost);
    }

    public static Component getCostText(CoinValue cost) {
        return new TextComponent(cost.getString()).m_130940_(ChatFormatting.YELLOW);
    }
}

