/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blockentity.UniversalItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.UniversalTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.items.tooltips.LCTooltips;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ItemTraderServerBlock
extends RotatableBlock
implements ITraderBlock,
EntityBlock {
    public static final int SMALL_SERVER_COUNT = 3;
    public static final int MEDIUM_SERVER_COUNT = 6;
    public static final int LARGE_SERVER_COUNT = 12;
    public static final int EXTRA_LARGE_SERVER_COUNT = 16;
    final int tradeCount;

    public ItemTraderServerBlock(BlockBehaviour.Properties properties, int tradeCount) {
        super(properties);
        this.tradeCount = tradeCount;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new UniversalItemTraderBlockEntity(pos, state, this.tradeCount);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof UniversalTraderBlockEntity && player instanceof Player) {
            UniversalTraderBlockEntity trader = (UniversalTraderBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                trader.init((Player)player, stack.m_41786_().getString());
            } else {
                trader.init((Player)player);
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof UniversalTraderBlockEntity) {
            UniversalTraderBlockEntity trader = (UniversalTraderBlockEntity)blockEntity;
            if (!trader.canBreak(player)) {
                return;
            }
            trader.onDestroyed();
        }
        super.m_5707_(level, pos, state, player);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        UniversalTraderBlockEntity trader;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof UniversalTraderBlockEntity && (trader = (UniversalTraderBlockEntity)blockEntity).hasPermission(player, "openStorage")) {
            trader.openStorageMenu(player);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockEntity getBlockEntity(BlockState state, LevelAccessor level, BlockPos pos) {
        return level.m_7702_(pos);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, LCTooltips.ITEM_NETWORK_TRADER);
        super.m_5871_(stack, level, tooltip, flagIn);
    }
}

