/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.templates.interfaces;

import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public interface IRotatableBlock {
    public static BlockPos getRightPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            }
            case SOUTH: {
                return new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
            }
            case EAST: {
                return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            }
            case WEST: {
                return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
            }
        }
        return pos;
    }

    public static BlockPos getLeftPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
            }
            case SOUTH: {
                return new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            }
            case EAST: {
                return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
            }
            case WEST: {
                return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            }
        }
        return pos;
    }

    public static BlockPos getForwardPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
            }
            case SOUTH: {
                return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            }
            case EAST: {
                return new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            }
            case WEST: {
                return new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
            }
        }
        return pos;
    }

    public static BlockPos getBackwardPos(BlockPos pos, Direction facing) {
        switch (facing) {
            case NORTH: {
                return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() + 1);
            }
            case SOUTH: {
                return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_() - 1);
            }
            case EAST: {
                return new BlockPos(pos.m_123341_() - 1, pos.m_123342_(), pos.m_123343_());
            }
            case WEST: {
                return new BlockPos(pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_());
            }
        }
        return pos;
    }

    public static Vector3f getRightVect(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case SOUTH: {
                return new Vector3f(-1.0f, 0.0f, 0.0f);
            }
            case EAST: {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case WEST: {
                return new Vector3f(0.0f, 0.0f, -1.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public static Vector3f getLeftVect(Direction facing) {
        return MathUtil.VectorMult(IRotatableBlock.getRightVect(facing), -1.0f);
    }

    public static Vector3f getForwardVect(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Vector3f(0.0f, 0.0f, -1.0f);
            }
            case SOUTH: {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case EAST: {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case WEST: {
                return new Vector3f(-1.0f, 0.0f, 0.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public static Vector3f getBackwardVect(Direction facing) {
        return MathUtil.VectorMult(IRotatableBlock.getForwardVect(facing), -1.0f);
    }

    public static Vector3f getOffsetVect(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Vector3f(0.0f, 0.0f, 1.0f);
            }
            case SOUTH: {
                return new Vector3f(1.0f, 0.0f, 0.0f);
            }
            case WEST: {
                return new Vector3f(1.0f, 0.0f, 1.0f);
            }
        }
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public Direction getFacing(BlockState var1);
}

