/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.tradeinterface.templates;

import io.github.lightman314.lightmanscurrency.blockentity.TickableBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.interfaces.IOwnableBlock;
import io.github.lightman314.lightmanscurrency.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.blocks.util.TickerUtil;
import io.github.lightman314.lightmanscurrency.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.NonNullSupplier;

public abstract class TraderInterfaceBlock
extends RotatableBlock
implements EntityBlock,
IOwnableBlock {
    protected TraderInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTickerHelper(type, this.interfaceType(), TickableBlockEntity::tickHandler);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        TraderInterfaceBlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state)) != null) {
            BlockEntityUtil.sendUpdatePacket(blockEntity);
            blockEntity.openMenu(player);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        TraderInterfaceBlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state)) != null) {
            blockEntity.initOwner((Entity)player);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        TraderInterfaceBlockEntity blockEntity = this.getBlockEntity((LevelAccessor)level, pos, state);
        if (blockEntity != null) {
            if (!blockEntity.isOwner((Entity)player)) {
                return;
            }
            blockEntity.dumpContents(level, pos);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public boolean canBreak(Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        TraderInterfaceBlockEntity be = this.getBlockEntity(level, pos, state);
        if (be == null) {
            return true;
        }
        return be.isOwner((Entity)player);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.createBlockEntity(pos, state);
    }

    protected abstract BlockEntity createBlockEntity(BlockPos var1, BlockState var2);

    protected abstract BlockEntityType<?> interfaceType();

    protected final TraderInterfaceBlockEntity getBlockEntity(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof TraderInterfaceBlockEntity) {
            return (TraderInterfaceBlockEntity)be;
        }
        return null;
    }

    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return () -> new ArrayList();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, this.getItemTooltips());
        super.m_5871_(stack, level, tooltip, flagIn);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }
}

