/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.UniversalTraderButton;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageOpenTrades2;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class TradingTerminalScreen
extends Screen
implements ScrollBarWidget.IScrollable {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/trader_selection.png");
    public static final Comparator<UniversalTraderData> TERMINAL_SORTER = new TraderSorter(true, true, true);
    public static final Comparator<UniversalTraderData> NAME_ONLY_SORTER = new TraderSorter(false, false, false);
    private int xSize = 176;
    private int ySize = 187;
    private EditBox searchField;
    private static int scroll = 0;
    ScrollBarWidget scrollBar;
    List<UniversalTraderButton> traderButtons;
    private List<UniversalTraderData> filteredTraderList = new ArrayList<UniversalTraderData>();

    private List<UniversalTraderData> traderList() {
        List<UniversalTraderData> traderList = ClientTradingOffice.getTraderList();
        traderList.removeIf(d -> d instanceof AuctionHouseTrader && (Boolean)Config.SERVER.enableAuctionHouse.get() == false);
        traderList.sort(TERMINAL_SORTER);
        return traderList;
    }

    public TradingTerminalScreen() {
        super((Component)new TranslatableComponent("block.lightmanscurrency.terminal"));
    }

    protected void m_7856_() {
        super.m_7856_();
        int guiLeft = (this.f_96543_ - this.xSize) / 2;
        int guiTop = (this.f_96544_ - this.ySize) / 2;
        this.searchField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, guiLeft + 28, guiTop + 6, 101, 9, (Component)new TranslatableComponent("gui.lightmanscurrency.terminal.search")));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        this.scrollBar = (ScrollBarWidget)this.m_142416_((GuiEventListener)new ScrollBarWidget(guiLeft + 16 + 146, guiTop + 17, 152, this));
        this.initTraderButtons(guiLeft, guiTop);
        this.m_96624_();
        this.updateTraderList();
        this.validateScroll();
    }

    public boolean m_7043_() {
        return false;
    }

    private void initTraderButtons(int guiLeft, int guiTop) {
        this.traderButtons = new ArrayList<UniversalTraderButton>();
        for (int y = 0; y < 5; ++y) {
            UniversalTraderButton newButton = (UniversalTraderButton)this.m_142416_((GuiEventListener)new UniversalTraderButton(guiLeft + 15, guiTop + 18 + y * 30, this::OpenTrader, this.f_96547_));
            this.traderButtons.add(newButton);
        }
    }

    public void m_96624_() {
        super.m_96624_();
        this.searchField.m_94120_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            this.f_96541_ = Minecraft.m_91087_();
        }
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_93228_(poseStack, startX, startY, 0, 0, this.xSize, this.ySize);
        this.scrollBar.beforeWidgetRender(mouseY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_5534_(char c, int code) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_5534_(c, code)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int key, int scanCode, int mods) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_7933_(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return this.searchField.m_93696_() && this.searchField.m_94213_() && key != 256 || super.m_7933_(key, scanCode, mods);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseClicked(mouseX, mouseY, button);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollBar.onMouseReleased(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (scroll < this.getMaxScroll()) {
                this.setScroll(scroll + 1);
            }
        } else if (delta > 0.0 && scroll > 0) {
            this.setScroll(scroll - 1);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void OpenTrader(Button button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenTrades2(this.filteredTraderList.get(index).getTraderID()));
        }
    }

    private int getTraderIndex(Button button) {
        if (!this.traderButtons.contains(button)) {
            return -1;
        }
        int index = this.traderButtons.indexOf(button);
        return index += scroll;
    }

    private void updateTraderList() {
        this.filteredTraderList = TradingOffice.filterTraders(this.searchField.m_94155_(), this.traderList());
        this.validateScroll();
        this.updateTraderButtons();
    }

    private void updateTraderButtons() {
        int startIndex = scroll;
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }

    private void validateScroll() {
        scroll = Math.min(scroll, this.getMaxScroll());
    }

    @Override
    public int currentScroll() {
        return scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        scroll = newScroll;
        this.updateTraderButtons();
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.filteredTraderList.size() - this.traderButtons.size());
    }

    private static class TraderSorter
    implements Comparator<UniversalTraderData> {
        private final boolean creativeAtTop;
        private final boolean emptyAtBottom;
        private final boolean auctionHousePriority;

        private TraderSorter(boolean creativeAtTop, boolean emptyAtBottom, boolean auctionHousePriority) {
            this.creativeAtTop = creativeAtTop;
            this.emptyAtBottom = emptyAtBottom;
            this.auctionHousePriority = auctionHousePriority;
        }

        @Override
        public int compare(UniversalTraderData a, UniversalTraderData b) {
            try {
                int sort;
                boolean emptyB;
                boolean emptyA;
                if (this.auctionHousePriority) {
                    boolean ahA = a instanceof AuctionHouseTrader;
                    boolean ahB = b instanceof AuctionHouseTrader;
                    if (ahA && !ahB) {
                        return -1;
                    }
                    if (ahB && !ahA) {
                        return 1;
                    }
                }
                if (this.emptyAtBottom && (emptyA = a.hasNoValidTrades()) != (emptyB = b.hasNoValidTrades())) {
                    return emptyA ? 1 : -1;
                }
                if (this.creativeAtTop) {
                    if (a.getCoreSettings().isCreative() && !b.getCoreSettings().isCreative()) {
                        return -1;
                    }
                    if (b.getCoreSettings().isCreative() && !a.getCoreSettings().isCreative()) {
                        return 1;
                    }
                }
                if ((sort = a.getName().getString().toLowerCase().compareTo(b.getName().getString().toLowerCase())) == 0) {
                    sort = a.getCoreSettings().getOwnerName().compareToIgnoreCase(b.getCoreSettings().getOwnerName());
                }
                return sort;
            }
            catch (Throwable t) {
                return 0;
            }
        }
    }
}

