/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.paygate;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.paygate.PaygateTradeEditTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.PaygateTradeData;
import java.util.UUID;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.ItemLike;

public class PaygateTradeEditClientTab
extends TraderStorageClientTab<PaygateTradeEditTab>
implements TradeButtonArea.InteractionConsumer {
    TradeButton tradeDisplay;
    CoinValueInput priceSelection;
    EditBox durationInput;

    public PaygateTradeEditClientTab(TraderStorageScreen screen, PaygateTradeEditTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)ModItems.TRADING_CORE);
    }

    @Override
    public Component getTooltip() {
        return new TextComponent("");
    }

    @Override
    public boolean tabButtonVisible() {
        return false;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public int getTradeRuleTradeIndex() {
        return ((PaygateTradeEditTab)this.commonTab).getTradeIndex();
    }

    @Override
    public void onOpen() {
        PaygateTradeData trade = ((PaygateTradeEditTab)this.commonTab).getTrade();
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(this.menu::getContext, ((PaygateTradeEditTab)this.commonTab)::getTrade, button -> {}));
        this.tradeDisplay.move(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 18);
        this.priceSelection = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft() + 103 - 88, this.screen.getGuiTop() + 55, (Component)new TextComponent(""), trade == null ? CoinValue.EMPTY : trade.getCost(), this.font, this::onValueChanged, this.screen::addRenderableTabWidget));
        this.priceSelection.drawBG = false;
        this.priceSelection.init();
        int labelWidth = this.font.m_92852_((FormattedText)new TranslatableComponent("gui.lightmanscurrency.duration"));
        int unitWidth = this.font.m_92852_((FormattedText)new TranslatableComponent("gui.lightmanscurrency.duration.unit"));
        this.durationInput = this.screen.addRenderableTabWidget(new EditBox(this.font, this.screen.getGuiLeft() + 15 + labelWidth, this.screen.getGuiTop() + 38, this.screen.getXSize() - 30 - labelWidth - unitWidth, 18, (Component)new TextComponent("")));
        this.durationInput.m_94144_(String.valueOf(trade.getDuration()));
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (((PaygateTradeEditTab)this.commonTab).getTrade() == null) {
            return;
        }
        this.validateRenderables();
        this.font.m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.duration"), (float)(this.screen.getGuiLeft() + 13), (float)(this.screen.getGuiTop() + 42), 0x404040);
        int unitWidth = this.font.m_92852_((FormattedText)new TranslatableComponent("gui.lightmanscurrency.duration.unit"));
        this.font.m_92889_(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.duration.unit"), (float)(this.screen.getGuiLeft() + this.screen.getXSize() - unitWidth - 13), (float)(this.screen.getGuiTop() + 42), 0x404040);
    }

    private void validateRenderables() {
        boolean bl = this.priceSelection.f_93624_ = !((PaygateTradeEditTab)this.commonTab).getTrade().isTicketTrade();
        if (this.priceSelection.f_93624_) {
            this.priceSelection.tick();
        }
        TextInputUtil.whitelistInteger(this.durationInput, 1L, 1200L);
        int inputDuration = Math.max(TextInputUtil.getIntegerValue(this.durationInput, 1), 1);
        if (inputDuration != ((PaygateTradeEditTab)this.commonTab).getTrade().getDuration()) {
            ((PaygateTradeEditTab)this.commonTab).setDuration(inputDuration);
        }
    }

    @Override
    public void tick() {
        this.durationInput.m_94120_();
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
        this.tradeDisplay.renderTooltips(pose, mouseX, mouseY);
    }

    @Override
    public void receiveSelfMessage(CompoundTag message) {
        if (message.m_128441_("TradeIndex")) {
            ((PaygateTradeEditTab)this.commonTab).setTradeIndex(message.m_128451_("TradeIndex"));
        }
    }

    @Override
    public void onTradeButtonInputInteraction(ITrader trader, TradeButton.ITradeData trade, int index, int mouseButton) {
        if (trade instanceof PaygateTradeData) {
            PaygateTradeData t = (PaygateTradeData)trade;
            if (this.menu.m_142621_().m_41720_() == ModItems.TICKET_MASTER) {
                UUID ticketID = TicketItem.GetTicketID(this.menu.m_142621_());
                ((PaygateTradeEditTab)this.commonTab).setTicket(ticketID);
                return;
            }
            if (t.isTicketTrade()) {
                ((PaygateTradeEditTab)this.commonTab).setTicket(null);
                return;
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.onInteractionClick((int)mouseX, (int)mouseY, button, this);
        return false;
    }

    @Override
    public void onTradeButtonOutputInteraction(ITrader trader, TradeButton.ITradeData trade, int index, int mouseButton) {
    }

    @Override
    public void onTradeButtonInteraction(ITrader trader, TradeButton.ITradeData trade, int localMouseX, int localMouseY, int mouseButton) {
    }

    public void onValueChanged(CoinValue value) {
        ((PaygateTradeEditTab)this.commonTab).setPrice(value.copy());
    }
}

