/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank.WalletBankTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.menus.wallet.WalletBankMenu;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageSelectBankAccount;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class SelectionTab
extends WalletBankTab {
    Button buttonPersonalAccount;
    TeamSelectWidget teamSelection;

    public SelectionTab(WalletBankScreen screen) {
        super(screen);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42516_);
    }

    public MutableComponent getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.atm.selection");
    }

    @Override
    public void init() {
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 79, this.screen.getGuiTop() + 15, 5, TeamButton.Size.NARROW, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.screen.getFont());
        this.buttonPersonalAccount = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 15, 70, 20, (Component)new TranslatableComponent("gui.button.bank.playeraccount"), this::PressPersonalAccount));
        this.tick();
    }

    private boolean isTeamSelected() {
        return ((WalletBankMenu)this.screen.m_6262_()).getBankAccountReference().accountType == BankAccount.AccountType.Team;
    }

    private boolean isSelfSelected() {
        return ((WalletBankMenu)this.screen.m_6262_()).getBankAccount() == BankAccount.GenerateReference(((WalletBankMenu)this.screen.m_6262_()).getPlayer()).get();
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        for (Team team : ClientTradingOffice.getTeamList()) {
            if (!team.hasBankAccount() || !team.canAccessBankAccount(((WalletBankMenu)this.screen.m_6262_()).getPlayer())) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.isTeamSelected()) {
            return ClientTradingOffice.getTeam(((WalletBankMenu)this.screen.m_6262_()).getBankAccountReference().id);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            Team selectedTeam = this.selectedTeam();
            if (selectedTeam != null && team.getID().equals(selectedTeam.getID())) {
                return;
            }
            BankAccount.AccountReference account = BankAccount.GenerateReference(true, team);
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSelectBankAccount(account));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PressPersonalAccount(Button button) {
        BankAccount.AccountReference account = BankAccount.GenerateReference(((WalletBankMenu)this.screen.m_6262_()).getPlayer());
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSelectBankAccount(account));
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.screen.getFont().m_92889_(pose, (Component)this.getTooltip(), (float)this.screen.getGuiLeft() + 8.0f, (float)this.screen.getGuiTop() + 6.0f, 0x404040);
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY) {
        if (this.getTeamList().size() == 0) {
            TextRenderUtil.drawVerticallyCenteredMultilineText(pose, (Component)new TranslatableComponent("gui.lightmanscurrency.bank.noteamsavailable"), this.teamSelection.f_93620_ + 1, TeamButton.Size.NARROW.width - 2, this.teamSelection.f_93621_ + 1, this.teamSelection.m_93694_() - 2, 0xFFFFFF);
        }
    }

    @Override
    public void tick() {
        this.buttonPersonalAccount.f_93623_ = !this.isSelfSelected();
    }

    @Override
    public void onClose() {
    }
}

