/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankInteraction;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;

public class BankAccountWidget {
    public static final int MIN_WIDTH = 100;
    public static final int HEIGHT = 109;
    public static final int BUTTON_WIDTH = 70;
    private final IBankAccountWidget parent;
    private CoinValueInput amountSelection;
    Button buttonDeposit;
    Button buttonWithdraw;
    int y;
    int spacing;
    public boolean allowEmptyDeposits = true;

    public CoinValueInput getAmountSelection() {
        return this.amountSelection;
    }

    public BankAccountWidget(int y, IBankAccountWidget parent) {
        this(y, parent, 0);
    }

    public BankAccountWidget(int y, IBankAccountWidget parent, int spacing) {
        this.parent = parent;
        this.y = y;
        this.spacing = spacing;
        int screenMiddle = this.parent.getScreen().f_96543_ / 2;
        this.amountSelection = this.parent.addCustomWidget(new CoinValueInput(screenMiddle - 88, this.y, (Component)new TranslatableComponent("gui.lightmanscurrency.bank.amounttip"), CoinValue.EMPTY, this.parent.getFont(), value -> {}, this.parent::addCustomWidget));
        this.amountSelection.allowFreeToggle = false;
        this.amountSelection.init();
        this.buttonDeposit = this.parent.addCustomWidget(new Button(screenMiddle - 5 - 70, this.y + 69 + 5 + spacing, 70, 20, (Component)new TranslatableComponent("gui.button.bank.deposit"), this::OnDeposit));
        this.buttonWithdraw = this.parent.addCustomWidget(new Button(screenMiddle + 5, this.y + 69 + 5 + spacing, 70, 20, (Component)new TranslatableComponent("gui.button.bank.withdraw"), this::OnWithdraw));
        this.buttonWithdraw.f_93623_ = false;
        this.buttonDeposit.f_93623_ = false;
    }

    public void renderInfo(PoseStack pose) {
        this.renderInfo(pose, 0);
    }

    public void renderInfo(PoseStack pose, int yOffset) {
        int screenMiddle = this.parent.getScreen().f_96543_ / 2;
        Font font = this.parent.getFont();
        TranslatableComponent balanceComponent = this.parent.getBankAccount() == null ? new TranslatableComponent("gui.lightmanscurrency.bank.null") : new TranslatableComponent("gui.lightmanscurrency.bank.balance", new Object[]{this.parent.getBankAccount().getCoinStorage().getString("0")});
        int offset = font.m_92895_(balanceComponent.getString()) / 2;
        this.parent.getFont().m_92889_(pose, (Component)balanceComponent, (float)(screenMiddle - offset), (float)(this.y + 69 + 30 + this.spacing + yOffset), 0x404040);
    }

    public void tick() {
        this.amountSelection.tick();
        if (this.parent.getBankAccount() == null) {
            this.buttonWithdraw.f_93623_ = false;
            this.buttonDeposit.f_93623_ = false;
        } else {
            this.buttonDeposit.f_93623_ = MoneyUtil.getValue(this.parent.getCoinAccess()) > 0L && (this.allowEmptyDeposits || this.amountSelection.getCoinValue().getRawValue() > 0L);
            this.buttonWithdraw.f_93623_ = this.amountSelection.getCoinValue().getRawValue() > 0L;
        }
    }

    private void OnDeposit(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankInteraction(true, this.amountSelection.getCoinValue()));
        this.amountSelection.setCoinValue(CoinValue.EMPTY);
    }

    private void OnWithdraw(Button button) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankInteraction(false, this.amountSelection.getCoinValue()));
        this.amountSelection.setCoinValue(CoinValue.EMPTY);
    }

    public static interface IBankAccountWidget {
        public <T extends GuiEventListener & Widget> T addCustomWidget(T var1);

        public Font getFont();

        public Screen getScreen();

        public BankAccount getBankAccount();

        public Container getCoinAccess();
    }
}

