/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TabButton
extends Button {
    public static final ResourceLocation GUI_TEXTURE = TraderSettingsScreen.GUI_TEXTURE;
    public static final int SIZE = 25;
    public final ITab tab;
    private final Font font;
    private int rotation = 0;

    public TabButton(Button.OnPress pressable, Font font, ITab tab) {
        super(0, 0, 25, 25, (Component)new TextComponent(""), pressable);
        this.font = font;
        this.tab = tab;
    }

    public void reposition(int x, int y, int rotation) {
        this.f_93620_ = x;
        this.f_93621_ = y;
        this.rotation = MathUtil.clamp(rotation, 0, 3);
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        float r = (float)(this.getColor() >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.getColor() >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.getColor() & 0xFF) / 255.0f;
        float activeColor = this.f_93623_ ? 1.0f : 0.5f;
        RenderSystem.m_157429_((float)(r * activeColor), (float)(g * activeColor), (float)(b * activeColor), (float)1.0f);
        int xOffset = this.rotation < 2 ? 0 : this.f_93618_;
        int yOffset = (this.rotation % 2 == 0 ? 0 : 2 * this.f_93619_) + (this.f_93623_ ? 0 : this.f_93619_);
        this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 200 + xOffset, yOffset, this.f_93618_, this.f_93619_);
        RenderSystem.m_157429_((float)activeColor, (float)activeColor, (float)activeColor, (float)1.0f);
        this.tab.getIcon().render(matrixStack, (AbstractWidget)this, this.font, this.f_93620_ + 4, this.f_93621_ + 4);
    }

    protected int getColor() {
        return this.tab.getColor();
    }

    public void renderTooltip(PoseStack pose, int mouseX, int mouseY, Screen screen) {
        boolean wasActive = this.f_93623_;
        this.f_93623_ = true;
        if (this.f_93624_ && this.m_5953_(mouseX, mouseY)) {
            screen.m_96602_(pose, this.tab.getTooltip(), mouseX, mouseY);
        }
        this.f_93623_ = wasActive;
    }

    public static interface ITab {
        @Nonnull
        public IconData getIcon();

        public int getColor();

        public Component getTooltip();
    }
}

