/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.text;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.PlayerSuggestionsUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class PlayerInputBox
extends EditBox
implements ScrollBarWidget.IScrollable {
    public int maxSuggestions;
    public boolean suggestAbove = true;
    private final Font font;
    private int suggestionScroll = 0;
    private static final int HEIGHT_PER_SUGGESTION = 10;

    public PlayerInputBox(int x, int y, int width, int height, Font font) {
        this(x, y, width, height, 5, font);
    }

    public PlayerInputBox(int x, int y, int width, int height, int maxSuggestions, Font font) {
        super(font, x, y, width, height, (Component)new TextComponent(""));
        this.maxSuggestions = maxSuggestions;
        this.font = font;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.f_93624_ && mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_)) {
            if (this.suggestAbove) {
                return mouseY >= (double)(this.f_93621_ - this.getSuggestionHeight()) && mouseY < (double)(this.f_93621_ + this.f_93619_);
            }
            return mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_ + this.getSuggestionHeight());
        }
        return false;
    }

    private int getSuggestionHeight() {
        return Math.min(this.getSuggestions().size(), this.maxSuggestions) * 10;
    }

    public void m_6303_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        List<String> suggestions;
        if (this.m_94213_() && (suggestions = this.getSuggestions()).size() > 0) {
            int suggestionHeight = this.getSuggestionHeight();
            int startHeight = this.suggestAbove ? this.f_93621_ - suggestionHeight : this.f_93621_ + this.f_93619_;
            GuiComponent.m_93172_((PoseStack)pose, (int)this.f_93620_, (int)startHeight, (int)(this.f_93620_ + this.f_93618_), (int)(startHeight + suggestionHeight), (int)0);
            for (int i = this.suggestionScroll; i < suggestions.size() && i < this.suggestionScroll + this.maxSuggestions; ++i) {
                this.font.m_92889_(pose, TextRenderUtil.fitString(suggestions.get(i), this.f_93618_ - 4), (float)(this.f_93620_ + 2), (float)(startHeight + (i - this.suggestionScroll) * 10 + 1), 0xFFFFFF);
            }
        }
        super.m_6303_(pose, mouseX, mouseY, partialTicks);
    }

    public void m_94120_() {
        super.m_94120_();
        this.validateScroll();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.handleScrollWheel(delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void validateScroll() {
        this.suggestionScroll = MathUtil.clamp(this.suggestionScroll, 0, this.getMaxScroll());
    }

    private List<String> getSuggestions() {
        return PlayerSuggestionsUtil.getSuggestions(this.m_94155_());
    }

    @Override
    public int currentScroll() {
        return this.suggestionScroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.suggestionScroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return ScrollBarWidget.IScrollable.calculateMaxScroll(this.maxSuggestions, this.getSuggestions().size());
    }
}

