/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class ItemRenderUtil {
    public static final ResourceLocation EMPTY_SLOT_BG = new ResourceLocation("lightmanscurrency", "items/empty_item_slot");
    public static final Pair<ResourceLocation, ResourceLocation> BACKGROUND = Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_SLOT_BG);
    public static final int ITEM_BLIT_OFFSET = 100;
    private static ItemStack alexHead = null;

    public static ItemStack getAlexHead() {
        if (alexHead != null) {
            return alexHead;
        }
        ItemStack alexHead = new ItemStack((ItemLike)Items.f_42680_);
        CompoundTag headData = new CompoundTag();
        CompoundTag skullOwner = new CompoundTag();
        skullOwner.m_128385_("Id", new int[]{-731408145, -304985227, -1778597514, 158507129});
        CompoundTag properties = new CompoundTag();
        ListTag textureList = new ListTag();
        CompoundTag texture = new CompoundTag();
        texture.m_128359_("Value", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjNiMDk4OTY3MzQwZGFhYzUyOTI5M2MyNGUwNDkxMDUwOWIyMDhlN2I5NDU2M2MzZWYzMWRlYzdiMzc1MCJ9fX0=");
        textureList.add((Object)texture);
        properties.m_128365_("textures", (Tag)textureList);
        skullOwner.m_128365_("Properties", (Tag)properties);
        headData.m_128365_("SkullOwner", (Tag)skullOwner);
        alexHead.m_41751_(headData);
        return alexHead;
    }

    public static void drawItemStack(GuiComponent gui, Font font, ItemStack stack, int x, int y) {
        ItemRenderUtil.drawItemStack(gui, font, stack, x, y, null);
    }

    public static void drawItemStack(GuiComponent gui, Font font, ItemStack stack, int x, int y, @Nullable String customCount) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        LocalPlayer player = minecraft.f_91074_;
        Screen screen = minecraft.f_91080_;
        int imageWidth = 0;
        if (screen != null) {
            imageWidth = screen.f_96543_;
            if (screen instanceof AbstractContainerScreen) {
                imageWidth = ((AbstractContainerScreen)screen).getXSize();
            }
        }
        if (font == null) {
            font = minecraft.f_91062_;
        }
        gui.m_93250_(100);
        itemRenderer.f_115093_ = 100.0f;
        RenderSystem.m_69482_();
        itemRenderer.m_174229_((LivingEntity)player, stack, x, y, x + y * imageWidth);
        itemRenderer.m_115174_(font, stack, x, y, customCount);
        itemRenderer.f_115093_ = 0.0f;
        gui.m_93250_(0);
    }

    public static void drawSlotBackground(PoseStack matrixStack, int x, int y, Pair<ResourceLocation, ResourceLocation> background) {
        if (background == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)minecraft.m_91258_((ResourceLocation)background.getFirst()).apply((ResourceLocation)background.getSecond());
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
        Screen.m_93200_((PoseStack)matrixStack, (int)x, (int)y, (int)100, (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
    }

    public static List<Component> getTooltipFromItem(ItemStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        return stack.m_41651_((Player)minecraft.f_91074_, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
    }
}

