/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;

public class TextRenderUtil {
    public static Font getFont() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91062_;
    }

    public static Component fitString(String text, int width) {
        return TextRenderUtil.fitString(text, width, "...");
    }

    public static Component fitString(String text, int width, Style style) {
        return TextRenderUtil.fitString(text, width, "...", style);
    }

    public static Component fitString(String text, int width, String edge) {
        return TextRenderUtil.fitString((Component)new TextComponent(text), width, edge);
    }

    public static Component fitString(Component component, int width) {
        return TextRenderUtil.fitString(component.getString(), width, "...", component.m_7383_());
    }

    public static Component fitString(Component component, int width, String edge) {
        return TextRenderUtil.fitString(component.getString(), width, edge, component.m_7383_());
    }

    public static Component fitString(Component component, int width, Style style) {
        return TextRenderUtil.fitString(component.getString(), width, "...", style);
    }

    public static Component fitString(Component component, int width, String edge, Style style) {
        return TextRenderUtil.fitString(component.getString(), width, edge, style);
    }

    public static Component fitString(String text, int width, String edge, Style style) {
        Font font = TextRenderUtil.getFont();
        if (font.m_92852_((FormattedText)new TextComponent(text).m_130948_(style)) <= width) {
            return new TextComponent(text).m_130948_(style);
        }
        while (font.m_92852_((FormattedText)new TextComponent(text + edge).m_130948_(style)) > width && text.length() > 0) {
            text = text.substring(0, text.length() - 1);
        }
        return new TextComponent(text + edge).m_130948_(style);
    }

    public static void drawCenteredText(PoseStack pose, String string, int centerX, int yPos, int color) {
        TextRenderUtil.drawCenteredText(pose, (Component)new TextComponent(string), centerX, yPos, color);
    }

    public static void drawCenteredText(PoseStack pose, Component component, int centerX, int yPos, int color) {
        Font font = TextRenderUtil.getFont();
        int width = font.m_92852_((FormattedText)component);
        font.m_92889_(pose, component, (float)(centerX - width / 2), (float)yPos, color);
    }

    public static void drawRightEdgeText(PoseStack pose, String string, int rightPos, int yPos, int color) {
        TextRenderUtil.drawRightEdgeText(pose, (Component)new TextComponent(string), rightPos, yPos, color);
    }

    public static void drawRightEdgeText(PoseStack pose, Component component, int rightPos, int yPos, int color) {
        Font font = TextRenderUtil.getFont();
        int width = font.m_92852_((FormattedText)component);
        font.m_92889_(pose, component, (float)rightPos, (float)(yPos - width), color);
    }

    public static void drawCenteredMultilineText(PoseStack pose, String string, int leftPos, int width, int topPos, int color) {
        TextRenderUtil.drawCenteredMultilineText(pose, (Component)new TextComponent(string), leftPos, width, topPos, color);
    }

    public static void drawCenteredMultilineText(PoseStack pose, Component component, int leftPos, int width, int topPos, int color) {
        Font font = TextRenderUtil.getFont();
        List lines = font.m_92923_((FormattedText)component, width);
        float centerPos = (float)leftPos + (float)width / 2.0f;
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            int lineWidth = font.m_92724_(line);
            float f = centerPos - (float)lineWidth / 2.0f;
            Objects.requireNonNull(font);
            font.m_92877_(pose, line, f, (float)(topPos + 9 * i), color);
        }
    }

    public static void drawVerticallyCenteredMultilineText(PoseStack pose, String string, int leftPos, int width, int topPos, int height, int color) {
        TextRenderUtil.drawVerticallyCenteredMultilineText(pose, (Component)new TextComponent(string), leftPos, width, topPos, height, color);
    }

    public static void drawVerticallyCenteredMultilineText(PoseStack pose, Component component, int leftPos, int width, int topPos, int height, int color) {
        Font font = TextRenderUtil.getFont();
        List lines = font.m_92923_((FormattedText)component, width);
        float centerPos = (float)leftPos + (float)width / 2.0f;
        float f = (float)topPos + (float)height / 2.0f;
        Objects.requireNonNull(font);
        float startHeight = f - (float)(9 * lines.size()) / 2.0f;
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            int lineWidth = font.m_92724_(line);
            float f2 = centerPos - (float)lineWidth / 2.0f;
            Objects.requireNonNull(font);
            font.m_92877_(pose, line, f2, startHeight + (float)(9 * i), color);
        }
    }

    public static MutableComponent changeStyle(Component component, UnaryOperator<Style> styleChanges) {
        if (component instanceof MutableComponent) {
            MutableComponent mc = (MutableComponent)component;
            return mc.m_130938_(styleChanges);
        }
        return new TextComponent("").m_7220_(component).m_130948_(component.m_7383_()).m_130938_(styleChanges);
    }

    public static class TextFormatting {
        private Centering centering = Centering.MIDDLE_CENTER;
        private int color = 0xFFFFFF;

        public Centering centering() {
            return this.centering;
        }

        public int color() {
            return this.color;
        }

        private TextFormatting() {
        }

        public static TextFormatting create() {
            return new TextFormatting();
        }

        public TextFormatting topEdge() {
            this.centering = this.centering.makeTop();
            return this;
        }

        public TextFormatting middle() {
            this.centering = this.centering.makeMiddle();
            return this;
        }

        public TextFormatting bottomEdge() {
            this.centering = this.centering.makeBottom();
            return this;
        }

        public TextFormatting leftEdge() {
            this.centering = this.centering.makeLeft();
            return this;
        }

        public TextFormatting centered() {
            this.centering = this.centering.makeCenter();
            return this;
        }

        public TextFormatting rightEdge() {
            this.centering = this.centering.makeRight();
            return this;
        }

        public TextFormatting color(int color) {
            this.color = color;
            return this;
        }

        public static enum Centering {
            TOP_LEFT(-1, 1),
            TOP_CENTER(0, 1),
            TOP_RIGHT(1, 1),
            MIDDLE_LEFT(-1, 0),
            MIDDLE_CENTER(0, 0),
            MIDDLE_RIGHT(1, 0),
            BOTTOM_LEFT(-1, -1),
            BOTTOM_CENTER(0, -1),
            BOTTOM_RIGHT(1, -1);

            private final int horiz;
            private final int vert;

            private Centering(int horiz, int vert) {
                this.horiz = horiz;
                this.vert = vert;
            }

            public boolean isTop() {
                return this.vert > 0;
            }

            public boolean isMiddle() {
                return this.vert == 0;
            }

            public boolean isBottom() {
                return this.vert < 0;
            }

            public boolean isLeft() {
                return this.horiz < 0;
            }

            public boolean isCenter() {
                return this.horiz == 0;
            }

            public boolean isRight() {
                return this.horiz > 1;
            }

            public Centering makeTop() {
                return this.of(this.horiz, 1);
            }

            public Centering makeMiddle() {
                return this.of(this.horiz, 0);
            }

            public Centering makeBottom() {
                return this.of(this.horiz, -1);
            }

            public Centering makeLeft() {
                return this.of(-1, this.vert);
            }

            public Centering makeCenter() {
                return this.of(0, this.vert);
            }

            public Centering makeRight() {
                return this.of(1, this.vert);
            }

            private Centering of(int horiz, int vert) {
                for (Centering c : Centering.values()) {
                    if (c.horiz != horiz || c.vert != vert) continue;
                    return c;
                }
                return this;
            }
        }
    }
}

