/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class CommandBalTop {
    public static final int ENTRIES_PER_PAGE = 10;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder lcAdminCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcbaltop").executes(context -> CommandBalTop.execute((CommandContext<CommandSourceStack>)context, 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(CommandBalTop::executePage));
        dispatcher.register(lcAdminCommand);
    }

    static int executePage(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        return CommandBalTop.execute(commandContext, IntegerArgumentType.getInteger(commandContext, (String)"page"));
    }

    static int execute(CommandContext<CommandSourceStack> commandContext, int page) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        List<BankAccount.AccountReference> allAccounts = TradingOffice.getPlayerBankAccounts();
        List<Team> allTeams = TradingOffice.getTeams();
        for (Team team : allTeams) {
            if (!team.hasBankAccount()) continue;
            allAccounts.add(BankAccount.GenerateReference(false, team));
        }
        while (allAccounts.remove(null)) {
        }
        allAccounts.sort(new AccountSorter());
        int startIndex = (page - 1) * 10;
        if (startIndex >= allAccounts.size()) {
            source.m_81352_((Component)new TranslatableComponent("command.lightmanscurrency.lcbaltop.error.page"));
            return 0;
        }
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcbaltop.title").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GOLD), false);
        source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcbaltop.page", new Object[]{page, CommandBalTop.getMaxPage(allAccounts.size())}).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GOLD), false);
        for (int i = startIndex; i < startIndex + 10 && i < allAccounts.size(); ++i) {
            try {
                BankAccount account = allAccounts.get(i).get();
                MutableComponent name = account.getName();
                String amount = account.getCoinStorage().getString("0");
                source.m_81354_((Component)new TranslatableComponent("command.lightmanscurrency.lcbaltop.entry", new Object[]{i + 1, name, amount}), false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    private static int getMaxPage(int listSize) {
        return (listSize - 1) / 10 + 1;
    }

    private static class AccountSorter
    implements Comparator<BankAccount.AccountReference> {
        private AccountSorter() {
        }

        @Override
        public int compare(BankAccount.AccountReference o1, BankAccount.AccountReference o2) {
            long bal2;
            BankAccount a2;
            BankAccount a1 = o1 == null ? null : o1.get();
            BankAccount bankAccount = a2 = o2 == null ? null : o2.get();
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            long bal1 = a1.getCoinStorage().getRawValue();
            if (bal1 > (bal2 = a2.getCoinStorage().getRawValue())) {
                return -1;
            }
            if (bal2 > bal1) {
                return 1;
            }
            return a1.getName().getString().toLowerCase().compareTo(a2.getName().getString().toLowerCase());
        }
    }
}

