/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class LowBalanceNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "bank_low_balance");
    private Component accountName;
    private CoinValue value = new CoinValue(new CoinValue.CoinValuePair[0]);

    public LowBalanceNotification(Component accountName, CoinValue value) {
        this.accountName = accountName;
        this.value = value;
    }

    public LowBalanceNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public Notification.Category getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    public Component getMessage() {
        return new TranslatableComponent("notifications.message.bank_low_balance", new Object[]{this.value.getString()});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.accountName));
        this.value.writeToNBT(compound, "Amount");
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.accountName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        this.value.readFromNBT(compound, "Amount");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof LowBalanceNotification) {
            LowBalanceNotification lbn = (LowBalanceNotification)other;
            if (!lbn.accountName.getString().equals(this.accountName.getString())) {
                return false;
            }
            return lbn.value.getRawValue() == this.value.getRawValue();
        }
        return false;
    }
}

