/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.auction;

import io.github.lightman314.lightmanscurrency.common.notifications.types.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseNotification;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class AuctionHouseBidNotification
extends AuctionHouseNotification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "auction_house_outbid");
    List<ItemTradeNotification.ItemData> items;
    CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);
    String customer;

    public AuctionHouseBidNotification(AuctionTradeData trade) {
        this.cost = trade.getLastBidAmount().copy();
        this.customer = trade.getLastBidPlayer().lastKnownName();
        this.items = new ArrayList<ItemTradeNotification.ItemData>();
        for (int i = 0; i < trade.getAuctionItems().size(); ++i) {
            this.items.add(new ItemTradeNotification.ItemData(trade.getAuctionItems().get(i)));
        }
    }

    public AuctionHouseBidNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public Component getMessage() {
        Component itemText = this.getItemNames(this.items);
        TextComponent cost = new TextComponent(this.cost.getString("0"));
        return new TranslatableComponent("notifications.message.auction.outbid", new Object[]{this.customer, itemText, cost});
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        ListTag itemList = new ListTag();
        for (ItemTradeNotification.ItemData item : this.items) {
            itemList.add((Object)item.save());
        }
        compound.m_128365_("Items", (Tag)itemList);
        this.cost.writeToNBT(compound, "Price");
        compound.m_128359_("Customer", this.customer);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        ListTag itemList = compound.m_128437_("Items", 10);
        this.items = new ArrayList<ItemTradeNotification.ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(new ItemTradeNotification.ItemData(itemList.m_128728_(i)));
        }
        this.cost.readFromNBT(compound, "Price");
        this.customer = compound.m_128461_("Customer");
    }
}

