/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.teams;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.notifications.types.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Team {
    public static final int MAX_NAME_LENGTH = 32;
    public static final String CATEGORY_MEMBER = "MEMBER";
    public static final String CATEGORY_ADMIN = "ADMIN";
    public static final String CATEGORY_REMOVE = "REMOVE";
    public static final String CATEGORY_OWNER = "OWNER";
    final UUID id;
    PlayerReference owner = null;
    String teamName = "Some Team";
    private boolean isClient = false;
    List<PlayerReference> admins = Lists.newArrayList();
    List<PlayerReference> members = Lists.newArrayList();
    int bankAccountLimit = 2;
    BankAccount bankAccount = null;

    public UUID getID() {
        return this.id;
    }

    public PlayerReference getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.teamName;
    }

    public void flagAsClient() {
        this.isClient = true;
    }

    public List<PlayerReference> getAdmins() {
        return this.admins;
    }

    public List<PlayerReference> getMembers() {
        return this.members;
    }

    public List<PlayerReference> getAllMembers() {
        ArrayList<PlayerReference> result = new ArrayList<PlayerReference>();
        result.addAll(this.members);
        result.addAll(this.admins);
        result.add(this.owner);
        return result;
    }

    public int getBankLimit() {
        return this.bankAccountLimit;
    }

    public boolean hasBankAccount() {
        return this.bankAccount != null;
    }

    public boolean canAccessBankAccount(Player player) {
        if (this.bankAccountLimit < 1) {
            return this.isMember(player);
        }
        if (this.bankAccountLimit < 2) {
            return this.isAdmin(player);
        }
        return this.isOwner(player);
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public boolean isOwner(Player player) {
        return this.owner != null && this.owner.is((Entity)player) || TradingOffice.isAdminPlayer(player);
    }

    public boolean isOwner(UUID playerID) {
        return this.owner != null && this.owner.is(playerID);
    }

    public boolean isAdmin(Player player) {
        return PlayerReference.listContains(this.admins, player.m_142081_()) || this.isOwner(player);
    }

    public boolean isAdmin(UUID playerID) {
        return PlayerReference.listContains(this.admins, playerID) || this.isOwner(playerID);
    }

    public boolean isMember(Player player) {
        return PlayerReference.listContains(this.members, player.m_142081_()) || this.isAdmin(player);
    }

    public boolean isMember(UUID playerID) {
        return PlayerReference.listContains(this.members, playerID) || this.isAdmin(playerID);
    }

    public void changeAddMember(Player requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_MEMBER);
    }

    public void changeAddAdmin(Player requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_ADMIN);
    }

    public void changeRemoveMember(Player requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_REMOVE);
    }

    public void changeOwner(Player requestor, String name) {
        this.changeAny(requestor, name, CATEGORY_OWNER);
    }

    public void changeName(Player requestor, String newName) {
        if (this.isAdmin(requestor)) {
            this.teamName = newName;
            if (this.bankAccount != null) {
                this.bankAccount.updateOwnersName(this.teamName);
            }
            this.markDirty();
        }
    }

    public void changeAny(Player requestor, String playerName, String category) {
        GameProfile profile;
        if (category.contentEquals(CATEGORY_MEMBER) && this.isAdmin(requestor)) {
            GameProfile profile2 = this.getProfile(playerName);
            if (profile2 != null) {
                if (this.isMember(profile2.getId())) {
                    return;
                }
                this.members.add(PlayerReference.of(profile2));
                this.markDirty();
            }
        } else if (category.contentEquals(CATEGORY_ADMIN) && this.isAdmin(requestor)) {
            GameProfile profile3 = this.getProfile(playerName);
            if (profile3 != null) {
                if (this.isAdmin(profile3.getId())) {
                    if (this.isOwner(profile3.getId())) {
                        return;
                    }
                    if (PlayerReference.of(requestor).is(profile3) || this.isOwner(requestor)) {
                        boolean notFound = true;
                        for (int i = 0; notFound && i < this.admins.size(); ++i) {
                            if (!this.admins.get(i).is(profile3)) continue;
                            notFound = false;
                            this.admins.remove(i);
                        }
                        this.members.add(PlayerReference.of(profile3));
                        this.markDirty();
                    }
                } else if (this.isOwner(requestor)) {
                    if (this.isMember(profile3.getId())) {
                        boolean notFound = true;
                        for (int i = 0; notFound && i < this.members.size(); ++i) {
                            if (!this.members.get(i).is(profile3)) continue;
                            notFound = false;
                            this.members.remove(i);
                        }
                    }
                    this.admins.add(PlayerReference.of(profile3));
                    this.markDirty();
                }
            }
        } else if (category.contentEquals(CATEGORY_REMOVE) && (this.isAdmin(requestor) || PlayerReference.of(requestor).is(playerName))) {
            GameProfile profile4 = this.getProfile(playerName);
            if (profile4 != null) {
                if (!this.isMember(profile4.getId())) {
                    return;
                }
                if (this.isAdmin(profile4.getId()) && !this.isOwner(requestor) && !PlayerReference.of(requestor).is(profile4)) {
                    return;
                }
                if (this.isOwner(profile4.getId())) {
                    return;
                }
                boolean notFound = true;
                if (this.isAdmin(profile4.getId())) {
                    for (int i = 0; notFound && i < this.admins.size(); ++i) {
                        if (!this.admins.get(i).is(profile4)) continue;
                        notFound = false;
                        this.admins.remove(i);
                    }
                } else {
                    for (int i = 0; notFound && i < this.members.size(); ++i) {
                        if (!this.members.get(i).is(profile4)) continue;
                        notFound = false;
                        this.members.remove(i);
                    }
                }
                if (notFound) {
                    return;
                }
                this.markDirty();
            }
        } else if (category.contentEquals(CATEGORY_OWNER) && this.isOwner(requestor) && (profile = this.getProfile(playerName)) != null) {
            int i;
            if (this.owner.is(profile)) {
                return;
            }
            this.admins.add(this.owner);
            this.owner = PlayerReference.of(profile);
            for (i = 0; i < this.admins.size(); ++i) {
                if (!this.admins.get(i).is(this.owner)) continue;
                this.admins.remove(i--);
            }
            for (i = 0; i < this.members.size(); ++i) {
                if (!this.members.get(i).is(this.owner)) continue;
                this.members.remove(i--);
            }
            this.markDirty();
        }
    }

    public void createBankAccount(Player requestor) {
        if (this.hasBankAccount() || !this.isOwner(requestor)) {
            return;
        }
        this.bankAccount = new BankAccount(() -> this.markDirty());
        this.bankAccount.updateOwnersName(this.teamName);
        this.bankAccount.setNotificationConsumer(this::notificationGenerator);
        this.markDirty();
    }

    private void notificationGenerator(Component accountName, CoinValue value) {
        ArrayList<PlayerReference> sendTo = new ArrayList<PlayerReference>();
        if (this.bankAccountLimit < 1) {
            sendTo.addAll(this.members);
        }
        if (this.bankAccountLimit < 2) {
            sendTo.addAll(this.admins);
        }
        sendTo.add(this.owner);
        for (PlayerReference player : sendTo) {
            if (player == null || player.id == null) continue;
            TradingOffice.pushNotification(player.id, new LowBalanceNotification(accountName, value));
        }
    }

    public void changeBankLimit(Player requestor, int newLimit) {
        if (this.isOwner(requestor) && this.bankAccountLimit != newLimit) {
            this.bankAccountLimit = newLimit;
            this.markDirty();
        }
    }

    public static int NextBankLimit(int currentLimit) {
        int result = currentLimit - 1;
        if (result < 0) {
            result = 2;
        }
        return result;
    }

    private GameProfile getProfile(String playerName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_129927_().m_10996_(playerName).orElse(null);
        }
        return null;
    }

    private Team(@Nonnull UUID teamID, @Nonnull PlayerReference owner, @Nonnull String name) {
        this.id = teamID;
        this.owner = owner;
        this.teamName = name;
    }

    public void markDirty() {
        if (!this.isClient) {
            TradingOffice.MarkTeamDirty(this.id);
        }
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        if (this.id != null) {
            compound.m_128362_("id", this.id);
        }
        if (this.owner != null) {
            compound.m_128365_("Owner", (Tag)this.owner.save());
        }
        compound.m_128359_("Name", this.teamName);
        ListTag memberList = new ListTag();
        for (int i = 0; i < this.members.size(); ++i) {
            CompoundTag thisMember = this.members.get(i).save();
            memberList.add((Object)thisMember);
        }
        compound.m_128365_("Members", (Tag)memberList);
        ListTag adminList = new ListTag();
        for (int i = 0; i < this.admins.size(); ++i) {
            CompoundTag thisAdmin = this.admins.get(i).save();
            adminList.add((Object)thisAdmin);
        }
        compound.m_128365_("Admins", (Tag)adminList);
        if (this.bankAccount != null) {
            compound.m_128365_("BankAccount", (Tag)this.bankAccount.save());
            compound.m_128405_("BankLimit", this.bankAccountLimit);
        }
        return compound;
    }

    public static Team load(@Nonnull CompoundTag compound) {
        PlayerReference owner = null;
        UUID id = null;
        if (compound.m_128441_("id")) {
            id = compound.m_128342_("id");
        }
        if (compound.m_128425_("Owner", 10)) {
            owner = PlayerReference.load(compound.m_128469_("Owner"));
        }
        String name = compound.m_128461_("Name");
        if (id != null && owner != null) {
            Team team = Team.of(id, owner, name);
            ListTag adminList = compound.m_128437_("Admins", 10);
            for (int i = 0; i < adminList.size(); ++i) {
                PlayerReference admin = PlayerReference.load(adminList.m_128728_(i));
                if (admin == null) continue;
                team.admins.add(admin);
            }
            ListTag memberList = compound.m_128437_("Members", 10);
            for (int i = 0; i < memberList.size(); ++i) {
                PlayerReference member = PlayerReference.load(memberList.m_128728_(i));
                if (member == null) continue;
                team.members.add(member);
            }
            if (compound.m_128425_("BankAccount", 10)) {
                team.bankAccount = new BankAccount(team::markDirty, compound.m_128469_("BankAccount"));
                if (compound.m_128425_("BankLimit", 3)) {
                    team.bankAccountLimit = compound.m_128451_("BankLimit");
                }
                team.bankAccount.updateOwnersName(team.teamName);
                team.bankAccount.setNotificationConsumer(team::notificationGenerator);
            }
            return team;
        }
        return null;
    }

    public static Team of(@Nonnull UUID id, @Nonnull PlayerReference owner, @Nonnull String name) {
        return new Team(id, owner, name);
    }

    public static TeamReference referenceOf(@Nullable UUID id) {
        if (id == null) {
            return null;
        }
        return new TeamReference(id);
    }

    public static Comparator<Team> sorterFor(Player player) {
        return new TeamSorter(player);
    }

    public static class TeamReference {
        UUID teamID;

        private TeamReference(UUID teamID) {
            this.teamID = teamID;
        }

        public UUID getID() {
            return this.teamID;
        }

        @Nullable
        public Team getTeam(boolean isClient) {
            if (isClient) {
                return ClientTradingOffice.getTeam(this.teamID);
            }
            return TradingOffice.getTeam(this.teamID);
        }
    }

    private static class TeamSorter
    implements Comparator<Team> {
        private final Player player;

        private TeamSorter(Player player) {
            this.player = player;
        }

        @Override
        public int compare(Team o1, Team o2) {
            if (o1.isOwner(this.player) && !o2.isOwner(this.player)) {
                return -1;
            }
            if (!o1.isOwner(this.player) && o2.isOwner(this.player)) {
                return 1;
            }
            if (o1.isAdmin(this.player) && !o2.isAdmin(this.player)) {
                return -1;
            }
            if (!o1.isAdmin(this.player) && o2.isAdmin(this.player)) {
                return 1;
            }
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

