/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.events;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class TradeEvent
extends Event {
    private final PlayerReference player;
    private final TradeData trade;
    private final ITrader trader;

    public final PlayerReference getPlayerReference() {
        return this.player;
    }

    @Deprecated
    public final Player getPlayer() {
        return this.player.getPlayer();
    }

    public final TradeData getTrade() {
        return this.trade;
    }

    public final ITrader getTrader() {
        return this.trader;
    }

    protected TradeEvent(PlayerReference player, TradeData trade, ITrader trader) {
        this.player = player;
        this.trade = trade;
        this.trader = trader;
    }

    public static class PostTradeEvent
    extends TradeEvent {
        private boolean isDirty = false;
        private final CoinValue pricePaid;

        public CoinValue getPricePaid() {
            return this.pricePaid;
        }

        public PostTradeEvent(PlayerReference player, TradeData trade, ITrader trader, CoinValue pricePaid) {
            super(player, trade, trader);
            this.pricePaid = pricePaid;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void markDirty() {
            this.isDirty = true;
        }

        public void clean() {
            this.isDirty = false;
        }
    }

    public static class TradeCostEvent
    extends TradeEvent {
        private double costMultiplier = 1.0;
        CoinValue currentCost;

        public double getCostMultiplier() {
            return this.costMultiplier;
        }

        public void applyCostMultiplier(double newCostMultiplier) {
            this.costMultiplier = MathUtil.clamp(this.costMultiplier * newCostMultiplier, 0.0, 2.0);
        }

        public void setCostMultiplier(double newCostMultiplier) {
            this.costMultiplier = MathUtil.clamp(newCostMultiplier, 0.0, 2.0);
        }

        public CoinValue getBaseCost() {
            return this.currentCost;
        }

        public CoinValue getCostResult() {
            return this.currentCost.ApplyMultiplier(this.costMultiplier);
        }

        public TradeCostEvent(PlayerReference player, TradeData trade, ITrader trader) {
            super(player, trade, trader);
            this.currentCost = trade.getCost();
        }
    }

    @Cancelable
    public static class PreTradeEvent
    extends TradeEvent {
        private final List<AlertData> alerts = Lists.newArrayList();

        public PreTradeEvent(PlayerReference player, TradeData trade, ITrader trader) {
            super(player, trade, trader);
        }

        @Deprecated
        public void denyTrade(Component reason) {
            this.addAlert(AlertData.convert(reason), true);
        }

        public void addAlert(AlertData alert, boolean cancelTrade) {
            this.alerts.add(alert);
            if (cancelTrade) {
                this.setCanceled(true);
            }
        }

        public void addHelpful(MutableComponent message) {
            this.addAlert(AlertData.helpful(message), false);
        }

        public void addWarning(MutableComponent message) {
            this.addAlert(AlertData.warn(message), false);
        }

        public void addError(MutableComponent message) {
            this.addAlert(AlertData.error(message), false);
        }

        public void addDenial(MutableComponent message) {
            this.addAlert(AlertData.error(message), true);
        }

        @Deprecated
        public List<Component> getDenialReasons() {
            ArrayList<Component> text = new ArrayList<Component>();
            for (AlertData a : this.alerts) {
                text.add((Component)a.getFormattedMessage());
            }
            return text;
        }

        public List<AlertData> getAlertInfo() {
            return this.alerts;
        }
    }
}

